// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Represents a single block in a block blob. It describes the block's ID and size.
 */
@Fluent
public final class Block implements XmlSerializable<Block> {
    /*
     * The base64 encoded block ID.
     */
    private String name;

    /*
     * The block size in bytes.
     */
    private long sizeLong;

    /*
     * The SizeInt property.
     */
    private int sizeInt;

    /**
     * Creates an instance of Block class.
     */
    public Block() {
    }

    /**
     * Get the name property: The base64 encoded block ID.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The base64 encoded block ID.
     * 
     * @param name the name value to set.
     * @return the Block object itself.
     */
    public Block setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sizeLong property: The block size in bytes.
     * 
     * @return the sizeLong value.
     */
    public long getSizeLong() {
        return this.sizeLong;
    }

    /**
     * Set the sizeLong property: The block size in bytes.
     * 
     * @param sizeLong the sizeLong value to set.
     * @return the Block object itself.
     */
    public Block setSizeLong(long sizeLong) {
        this.sizeLong = sizeLong;
        return this;
    }

    /**
     * Get the sizeInt property: The SizeInt property.
     * 
     * @return the sizeInt value.
     * @deprecated Use {@link #getSizeLong()}
     */
    @Deprecated
    public int getSize() {
        int returnValue = this.sizeInt;
        return (int) this.sizeLong; // return returnValue;
    }

    /**
     * Set the sizeInt property: The SizeInt property.
     * 
     * @param sizeInt the sizeInt value to set.
     * @return the Block object itself.
     * @deprecated Use {@link #setSizeLong(long)}
     */
    @Deprecated
    public Block setSize(int sizeInt) {
        this.sizeInt = sizeInt;
        Block returnValue = this;
        return returnValue.setSizeLong((long) sizeInt);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Block" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeLongElement("Size", this.sizeLong);
        xmlWriter.writeIntElement("SizeInt", this.sizeInt);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of Block from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of Block if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the Block.
     */
    public static Block fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of Block from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of Block if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the Block.
     */
    public static Block fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Block" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            Block deserializedBlock = new Block();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlock.name = reader.getStringElement();
                } else if ("Size".equals(elementName.getLocalPart())) {
                    deserializedBlock.sizeLong = reader.getLongElement();
                } else if ("SizeInt".equals(elementName.getLocalPart())) {
                    deserializedBlock.sizeInt = reader.getIntElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlock;
        });
    }
}
