// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An Azure Storage blob.
 */
@Fluent
public final class BlobItemInternal implements XmlSerializable<BlobItemInternal> {
    /*
     * The Name property.
     */
    private BlobName name;

    /*
     * The Deleted property.
     */
    private boolean deleted;

    /*
     * The Snapshot property.
     */
    private String snapshot;

    /*
     * The VersionId property.
     */
    private String versionId;

    /*
     * The IsCurrentVersion property.
     */
    private Boolean isCurrentVersion;

    /*
     * Properties of a blob
     */
    private BlobItemPropertiesInternal properties;

    /*
     * Dictionary of <string>
     */
    private Map<String, String> metadata;

    /*
     * Blob tags
     */
    private BlobTags blobTags;

    /*
     * Dictionary of <string>
     */
    private Map<String, String> objectReplicationMetadata;

    /*
     * The HasVersionsOnly property.
     */
    private Boolean hasVersionsOnly;

    /*
     * The IsPrefix property.
     */
    private Boolean isPrefix;

    /**
     * Creates an instance of BlobItemInternal class.
     */
    public BlobItemInternal() {
    }

    /**
     * Get the name property: The Name property.
     * 
     * @return the name value.
     */
    public BlobName getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     * 
     * @param name the name value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setName(BlobName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the deleted property: The Deleted property.
     * 
     * @return the deleted value.
     */
    public boolean isDeleted() {
        return this.deleted;
    }

    /**
     * Set the deleted property: The Deleted property.
     * 
     * @param deleted the deleted value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * Get the snapshot property: The Snapshot property.
     * 
     * @return the snapshot value.
     */
    public String getSnapshot() {
        return this.snapshot;
    }

    /**
     * Set the snapshot property: The Snapshot property.
     * 
     * @param snapshot the snapshot value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    /**
     * Get the versionId property: The VersionId property.
     * 
     * @return the versionId value.
     */
    public String getVersionId() {
        return this.versionId;
    }

    /**
     * Set the versionId property: The VersionId property.
     * 
     * @param versionId the versionId value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    /**
     * Get the isCurrentVersion property: The IsCurrentVersion property.
     * 
     * @return the isCurrentVersion value.
     */
    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    /**
     * Set the isCurrentVersion property: The IsCurrentVersion property.
     * 
     * @param isCurrentVersion the isCurrentVersion value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    /**
     * Get the properties property: Properties of a blob.
     * 
     * @return the properties value.
     */
    public BlobItemPropertiesInternal getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a blob.
     * 
     * @param properties the properties value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setProperties(BlobItemPropertiesInternal properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @param metadata the metadata value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the blobTags property: Blob tags.
     * 
     * @return the blobTags value.
     */
    public BlobTags getBlobTags() {
        return this.blobTags;
    }

    /**
     * Set the blobTags property: Blob tags.
     * 
     * @param blobTags the blobTags value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setBlobTags(BlobTags blobTags) {
        this.blobTags = blobTags;
        return this;
    }

    /**
     * Get the objectReplicationMetadata property: Dictionary of &lt;string&gt;.
     * 
     * @return the objectReplicationMetadata value.
     */
    public Map<String, String> getObjectReplicationMetadata() {
        return this.objectReplicationMetadata;
    }

    /**
     * Set the objectReplicationMetadata property: Dictionary of &lt;string&gt;.
     * 
     * @param objectReplicationMetadata the objectReplicationMetadata value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setObjectReplicationMetadata(Map<String, String> objectReplicationMetadata) {
        this.objectReplicationMetadata = objectReplicationMetadata;
        return this;
    }

    /**
     * Get the hasVersionsOnly property: The HasVersionsOnly property.
     * 
     * @return the hasVersionsOnly value.
     */
    public Boolean isHasVersionsOnly() {
        return this.hasVersionsOnly;
    }

    /**
     * Set the hasVersionsOnly property: The HasVersionsOnly property.
     * 
     * @param hasVersionsOnly the hasVersionsOnly value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setHasVersionsOnly(Boolean hasVersionsOnly) {
        this.hasVersionsOnly = hasVersionsOnly;
        return this;
    }

    /**
     * Get the isPrefix property: The IsPrefix property.
     * 
     * @return the isPrefix value.
     */
    public Boolean isPrefix() {
        return this.isPrefix;
    }

    /**
     * Set the isPrefix property: The IsPrefix property.
     * 
     * @param isPrefix the isPrefix value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setIsPrefix(Boolean isPrefix) {
        this.isPrefix = isPrefix;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Blob" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.name, "Name");
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeStringElement("VersionId", this.versionId);
        xmlWriter.writeBooleanElement("IsCurrentVersion", this.isCurrentVersion);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeXml(this.blobTags, "Tags");
        if (this.objectReplicationMetadata != null) {
            xmlWriter.writeStartElement("OrMetadata");
            for (Map.Entry<String, String> entry : this.objectReplicationMetadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement("HasVersionsOnly", this.hasVersionsOnly);
        xmlWriter.writeBooleanElement("IsPrefix", this.isPrefix);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobItemInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobItemInternal if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobItemInternal.
     */
    public static BlobItemInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobItemInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobItemInternal if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobItemInternal.
     */
    public static BlobItemInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Blob" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobItemInternal deserializedBlobItemInternal = new BlobItemInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.name = BlobName.fromXml(reader, "Name");
                } else if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.deleted = reader.getBooleanElement();
                } else if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.snapshot = reader.getStringElement();
                } else if ("VersionId".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.versionId = reader.getStringElement();
                } else if ("IsCurrentVersion".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.isCurrentVersion = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.properties = BlobItemPropertiesInternal.fromXml(reader, "Properties");
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobItemInternal.metadata == null) {
                            deserializedBlobItemInternal.metadata = new LinkedHashMap<>();
                        }
                        deserializedBlobItemInternal.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else if ("Tags".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.blobTags = BlobTags.fromXml(reader, "Tags");
                } else if ("OrMetadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobItemInternal.objectReplicationMetadata == null) {
                            deserializedBlobItemInternal.objectReplicationMetadata = new LinkedHashMap<>();
                        }
                        deserializedBlobItemInternal.objectReplicationMetadata
                            .put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                } else if ("HasVersionsOnly".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.hasVersionsOnly = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("IsPrefix".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.isPrefix = reader.getNullableElement(Boolean::parseBoolean);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobItemInternal;
        });
    }
}
