// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockFromUrlHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsSealHeaders;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AppendBlobs.
 */
public final class AppendBlobsImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final AppendBlobsService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureBlobStorageImpl client;

    /**
     * Initializes an instance of AppendBlobsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    AppendBlobsImpl(AzureBlobStorageImpl client) {
        this.service
            = RestProxy.create(AppendBlobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureBlobStorageAppendBlobs to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureBlobStorageAppe")
    public interface AppendBlobsService {

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<AppendBlobsCreateHeaders, Void>> create(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> createNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<AppendBlobsCreateHeaders, Void> createSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> createNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlock(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> appendBlockNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlock(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> appendBlockNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<AppendBlobsAppendBlockHeaders, Void> appendBlockSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> appendBlockNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void>> appendBlockFromUrl(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> appendBlockFromUrlNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void> appendBlockFromUrlSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> appendBlockFromUrlNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-condition-maxsize") Long maxSize,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<AppendBlobsSealHeaders, Void>> seal(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> sealNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<AppendBlobsSealHeaders, Void> sealSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> sealNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-blob-condition-appendpos") Long appendPosition, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsCreateHeaders, Void>> createWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> createWithResponseAsync(containerName, blob, contentLength, timeout, metadata,
                leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString,
                immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsCreateHeaders, Void>> createWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "AppendBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service.create(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength, contentType,
            contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition,
            encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
            ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
            blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, String blob, long contentLength, Integer timeout,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return createWithResponseAsync(containerName, blob, contentLength, timeout, metadata, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry,
            immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, String blob, long contentLength, Integer timeout,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return createWithResponseAsync(containerName, blob, contentLength, timeout, metadata, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry,
            immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> createNoCustomHeadersWithResponseAsync(containerName, blob, contentLength, timeout,
                metadata, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
                blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "AppendBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service
            .createNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AppendBlobsCreateHeaders, Void> createWithResponse(String containerName, String blob,
        long contentLength, Integer timeout, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "AppendBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.createSync(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void create(String containerName, String blob, long contentLength, Integer timeout,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        createWithResponse(containerName, blob, contentLength, timeout, metadata, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry,
            immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Create Append Blob operation creates a new append blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        Integer timeout, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "AppendBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.createNoCustomHeadersSync(this.client.getUrl(), containerName, blob, blobType, timeout,
                contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl,
                metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName,
        String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout,
                transactionalContentMD5, transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName,
        String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .appendBlock(this.client.getUrl(), containerName, blob, comp, timeout, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                body, timeout, transactionalContentMD5, transactionalContentCrc64, leaseId, maxSize, appendPosition,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType,
                structuredContentLength, cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .appendBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName,
        String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout,
                transactionalContentMD5, transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName,
        String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .appendBlock(this.client.getUrl(), containerName, blob, comp, timeout, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockAsync(String containerName, String blob, long contentLength, BinaryData body,
        Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockAsync(String containerName, String blob, long contentLength, BinaryData body,
        Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return appendBlockWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                body, timeout, transactionalContentMD5, transactionalContentCrc64, leaseId, maxSize, appendPosition,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType,
                structuredContentLength, cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .appendBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AppendBlobsAppendBlockHeaders, Void> appendBlockWithResponse(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "appendblock";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.appendBlockSync(this.client.getUrl(), containerName, blob, comp, timeout, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void appendBlock(String containerName, String blob, long contentLength, BinaryData body, Integer timeout,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        appendBlockWithResponse(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            transactionalContentCrc64, leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam,
            Context.NONE);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob. The Append Block
     * operation is permitted only if the blob was created with x-ms-blob-type set to AppendBlob. Append Block is
     * supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> appendBlockNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        BinaryData body, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        try {
            final String comp = "appendblock";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.appendBlockNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, timeout,
                contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize,
                appendPosition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void>> appendBlockFromUrlWithResponseAsync(
        String containerName, String blob, String sourceUrl, long contentLength, String sourceRange,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, byte[] transactionalContentMD5,
        String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockFromUrlWithResponseAsync(containerName, blob, sourceUrl, contentLength,
                sourceRange, sourceContentMD5, sourceContentcrc64, timeout, transactionalContentMD5, leaseId, maxSize,
                appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince,
                sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void>> appendBlockFromUrlWithResponseAsync(
        String containerName, String blob, String sourceUrl, long contentLength, String sourceRange,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, byte[] transactionalContentMD5,
        String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service.appendBlockFromUrl(this.client.getUrl(), containerName, blob, comp, sourceUrl, sourceRange,
            sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength,
            transactionalContentMD5Converted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
            leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch,
            ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch,
            sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockFromUrlAsync(String containerName, String blob, String sourceUrl, long contentLength,
        String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return appendBlockFromUrlWithResponseAsync(containerName, blob, sourceUrl, contentLength, sourceRange,
            sourceContentMD5, sourceContentcrc64, timeout, transactionalContentMD5, leaseId, maxSize, appendPosition,
            ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince,
            sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo,
            encryptionScopeParam).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> appendBlockFromUrlAsync(String containerName, String blob, String sourceUrl, long contentLength,
        String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return appendBlockFromUrlWithResponseAsync(containerName, blob, sourceUrl, contentLength, sourceRange,
            sourceContentMD5, sourceContentcrc64, timeout, transactionalContentMD5, leaseId, maxSize, appendPosition,
            ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince,
            sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo,
            encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64,
        Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> appendBlockFromUrlNoCustomHeadersWithResponseAsync(containerName, blob, sourceUrl,
                contentLength, sourceRange, sourceContentMD5, sourceContentcrc64, timeout, transactionalContentMD5,
                leaseId, maxSize, appendPosition, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags,
                sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId,
                copySourceAuthorization, cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> appendBlockFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64,
        Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "appendblock";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service.appendBlockFromUrlNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, sourceUrl,
            sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength,
            transactionalContentMD5Converted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
            leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch,
            ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch,
            sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void> appendBlockFromUrlWithResponse(String containerName,
        String blob, String sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize,
        Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "appendblock";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.appendBlockFromUrlSync(this.client.getUrl(), containerName, blob, comp, sourceUrl,
                sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength,
                transactionalContentMD5Converted, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted,
                sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void appendBlockFromUrl(String containerName, String blob, String sourceUrl, long contentLength,
        String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        appendBlockFromUrlWithResponse(containerName, blob, sourceUrl, contentLength, sourceRange, sourceContentMD5,
            sourceContentcrc64, timeout, transactionalContentMD5, leaseId, maxSize, appendPosition, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince,
            sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam,
            Context.NONE);
    }

    /**
     * The Append Block operation commits a new block of data to the end of an existing append blob where the contents
     * are read from a source url. The Append Block operation is permitted only if the blob was created with
     * x-ms-blob-type set to AppendBlob. Append Block is supported only on version 2015-02-21 version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param contentLength The length of the request.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param maxSize Optional conditional header. The max length in bytes permitted for the append blob. If the Append
     * Block operation would cause the blob to exceed that limit or if the blob size is already greater than the value
     * specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP status code 412 -
     * Precondition Failed).
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> appendBlockFromUrlNoCustomHeadersWithResponse(String containerName, String blob,
        String sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64,
        Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "appendblock";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.appendBlockFromUrlNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp,
                sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength,
                transactionalContentMD5Converted, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted,
                sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsSealHeaders, Void>> sealWithResponseAsync(String containerName, String blob,
        Integer timeout, String requestId, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long appendPosition) {
        return FluxUtil
            .withContext(context -> sealWithResponseAsync(containerName, blob, timeout, requestId, leaseId,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, appendPosition, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsSealHeaders, Void>> sealWithResponseAsync(String containerName, String blob,
        Integer timeout, String requestId, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        final String comp = "seal";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .seal(this.client.getUrl(), containerName, blob, comp, timeout, this.client.getVersion(), requestId,
                leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, appendPosition,
                accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> sealAsync(String containerName, String blob, Integer timeout, String requestId, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        Long appendPosition) {
        return sealWithResponseAsync(containerName, blob, timeout, requestId, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, appendPosition)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> sealAsync(String containerName, String blob, Integer timeout, String requestId, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        Long appendPosition, Context context) {
        return sealWithResponseAsync(containerName, blob, timeout, requestId, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, appendPosition, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> sealNoCustomHeadersWithResponseAsync(String containerName, String blob, Integer timeout,
        String requestId, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, Long appendPosition) {
        return FluxUtil
            .withContext(context -> sealNoCustomHeadersWithResponseAsync(containerName, blob, timeout, requestId,
                leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, appendPosition, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> sealNoCustomHeadersWithResponseAsync(String containerName, String blob, Integer timeout,
        String requestId, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        final String comp = "seal";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .sealNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, this.client.getVersion(),
                requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch,
                appendPosition, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AppendBlobsSealHeaders, Void> sealWithResponse(String containerName, String blob,
        Integer timeout, String requestId, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        try {
            final String comp = "seal";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.sealSync(this.client.getUrl(), containerName, blob, comp, timeout, this.client.getVersion(),
                requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch,
                appendPosition, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void seal(String containerName, String blob, Integer timeout, String requestId, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        Long appendPosition) {
        sealWithResponse(containerName, blob, timeout, requestId, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, appendPosition, Context.NONE);
    }

    /**
     * The Seal operation seals the Append Blob to make it read-only. Seal is supported only on version 2019-12-12
     * version or later.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param appendPosition Optional conditional header, used only for the Append Block operation. A number indicating
     * the byte offset to compare. Append Block will succeed only if the append position is equal to this number. If it
     * is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     * Failed).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> sealNoCustomHeadersWithResponse(String containerName, String blob, Integer timeout,
        String requestId, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        try {
            final String comp = "seal";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.sealNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, timeout,
                this.client.getVersion(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, appendPosition, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }
}
