/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.storage.blob.HttpGetterInfo;
import com.azure.storage.blob.implementation.models.BlobsDownloadResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReliableDownload {
    private final BlobsDownloadResponse rawResponse;
    private final DownloadRetryOptions options;
    private final HttpGetterInfo info;
    private final Function<HttpGetterInfo, Mono<ReliableDownload>> getter;

    ReliableDownload(BlobsDownloadResponse rawResponse, DownloadRetryOptions options, HttpGetterInfo info, Function<HttpGetterInfo, Mono<ReliableDownload>> getter) {
        StorageImplUtils.assertNotNull((String)"getter", getter);
        StorageImplUtils.assertNotNull((String)"info", (Object)info);
        StorageImplUtils.assertNotNull((String)"info.eTag", (Object)info.getETag());
        this.rawResponse = rawResponse;
        this.options = options == null ? new DownloadRetryOptions() : options;
        this.info = info;
        this.getter = getter;
    }

    HttpRequest getRequest() {
        return this.rawResponse.getRequest();
    }

    int getStatusCode() {
        return this.rawResponse.getStatusCode();
    }

    HttpHeaders getHeaders() {
        return this.rawResponse.getHeaders();
    }

    BlobDownloadHeaders getDeserializedHeaders() {
        return (BlobDownloadHeaders)this.rawResponse.getDeserializedHeaders();
    }

    Flux<ByteBuffer> getValue() {
        Flux<ByteBuffer> value = this.options.getMaxRetryRequests() == 0 ? this.rawResponse.getValue() : this.applyReliableDownload(this.rawResponse.getValue(), -1, this.options);
        return value.switchIfEmpty((Publisher)Flux.just((Object)ByteBuffer.wrap(new byte[0])));
    }

    private Flux<ByteBuffer> tryContinueFlux(Throwable t, int retryCount, DownloadRetryOptions options) {
        if (retryCount > options.getMaxRetryRequests() || !(t instanceof IOException)) {
            return Flux.error((Throwable)t);
        }
        try {
            return this.getter.apply(this.info).flatMapMany(ignored -> this.applyReliableDownload(this.rawResponse.getValue(), retryCount, options));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ByteBuffer> applyReliableDownload(Flux<ByteBuffer> data, int currentRetryCount, DownloadRetryOptions options) {
        return data.doOnNext(buffer -> {
            this.info.setOffset(this.info.getOffset() + (long)buffer.remaining());
            if (this.info.getCount() != null) {
                this.info.setCount(this.info.getCount() - (long)buffer.remaining());
            }
        }).onErrorResume(t2 -> this.tryContinueFlux((Throwable)t2, currentRetryCount + 1, options));
    }
}

