/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class BlockBlobClient
extends BlobClientBase {
    private final ClientLogger logger = new ClientLogger(BlockBlobClient.class);
    private final BlockBlobAsyncClient client;
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobClient(BlockBlobAsyncClient client) {
        super(client);
        this.client = client;
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(false);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.exists().booleanValue()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.getBlobOutputStream(requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(null, null, null, null, requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return BlobOutputStream.blockBlobOutputStream(this.client, parallelTransferOptions, headers, metadata, tier, requestConditions);
    }

    public BlockBlobItem upload(InputStream data, long length) {
        return this.upload(data, length, false);
    }

    public BlockBlobItem upload(InputStream data, long length, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    public Response<BlockBlobItem> uploadWithResponse(InputStream data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux fbb = Utility.convertStreamToByteBuffer((InputStream)data, (long)length, (int)0x400000);
        Mono<Response<BlockBlobItem>> upload = this.client.uploadWithResponse((Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.elastic()), length, headers, metadata, tier, contentMd5, requestConditions, context);
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout(upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)e);
        }
    }

    public void stageBlock(String base64BlockId, InputStream data, long length) {
        this.stageBlockWithResponse(base64BlockId, data, length, null, null, null, Context.NONE);
    }

    public Response<Void> stageBlockWithResponse(String base64BlockId, InputStream data, long length, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux fbb = Utility.convertStreamToByteBuffer((InputStream)data, (long)length, (int)0x400000);
        Mono<Response<Void>> response = this.client.stageBlockWithResponse(base64BlockId, (Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.elastic()), length, contentMd5, leaseId, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void stageBlockFromUrl(String base64BlockId, String sourceUrl, BlobRange sourceRange) {
        this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, null, null, null, null, Context.NONE);
    }

    public Response<Void> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, sourceContentMd5, leaseId, sourceRequestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public BlockList listBlocks(BlockListType listType) {
        return (BlockList)this.listBlocksWithResponse(listType, null, null, Context.NONE).getValue();
    }

    public Response<BlockList> listBlocksWithResponse(BlockListType listType, String leaseId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.listBlocksWithResponse(listType, leaseId, context), (Duration)timeout);
    }

    public BlockBlobItem commitBlockList(List<String> base64BlockIds) {
        return this.commitBlockList(base64BlockIds, false);
    }

    public BlockBlobItem commitBlockList(List<String> base64BlockIds, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return (BlockBlobItem)this.commitBlockListWithResponse(base64BlockIds, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    public Response<BlockBlobItem> commitBlockListWithResponse(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<BlockBlobItem>> response = this.client.commitBlockListWithResponse(base64BlockIds, headers, metadata, tier, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }
}

