/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.common.StorageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class BlobInputStream
extends StorageInputStream {
    private final BlobAsyncClientBase blobClient;
    private final BlobRequestConditions accessCondition;

    BlobInputStream(BlobAsyncClient blobClient, BlobRequestConditions accessCondition) throws BlobStorageException {
        this(blobClient, 0L, null, accessCondition);
    }

    BlobInputStream(BlobAsyncClientBase blobClient, long blobRangeOffset, Long blobRangeLength, BlobRequestConditions accessCondition) throws BlobStorageException {
        super(blobRangeOffset, blobRangeLength, 0x400000, ((BlobProperties)blobClient.getProperties().block()).getBlobSize());
        this.blobClient = blobClient;
        this.accessCondition = accessCondition;
    }

    protected synchronized ByteBuffer dispatchRead(int readLength, long offset) throws IOException {
        try {
            ByteBuffer currentBuffer = (ByteBuffer)this.blobClient.downloadWithResponse(new BlobRange(offset, Long.valueOf(readLength)), null, this.accessCondition, false).flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue())).map(ByteBuffer::wrap)).block();
            this.bufferSize = readLength;
            this.bufferStartOffset = offset;
            return currentBuffer;
        }
        catch (BlobStorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException((Throwable)((Object)e));
            throw this.lastError;
        }
    }
}

