/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.AppendBlobAppendBlockFromUrlHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobAppendBlockHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobCreateHeaders;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AppendBlobAsyncClient
extends BlobAsyncClientBase {
    private final ClientLogger logger = new ClientLogger(AppendBlobAsyncClient.class);
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey);
    }

    public Mono<AppendBlobItem> create() {
        try {
            return this.create(false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<AppendBlobItem> create(boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.createWithResponse(null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<AppendBlobItem>> createWithResponse(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(headers, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> createWithResponse(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.appendBlobs().createWithRestResponseAsync(null, null, 0L, null, metadata, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, headers, this.getCustomerProvidedKey(), context).map(rb -> {
            AppendBlobCreateHeaders hd = (AppendBlobCreateHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), null, null);
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<AppendBlobItem> appendBlock(Flux<ByteBuffer> data, long length) {
        try {
            return this.appendBlockWithResponse(data, length, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<AppendBlobItem>> appendBlockWithResponse(Flux<ByteBuffer> data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.appendBlockWithResponse(data, length, contentMd5, appendBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> appendBlockWithResponse(Flux<ByteBuffer> data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions, Context context) {
        appendBlobRequestConditions = appendBlobRequestConditions == null ? new AppendBlobRequestConditions() : appendBlobRequestConditions;
        return this.azureBlobStorage.appendBlobs().appendBlockWithRestResponseAsync(null, null, data, length, null, contentMd5, null, appendBlobRequestConditions.getLeaseId(), appendBlobRequestConditions.getMaxSize(), appendBlobRequestConditions.getAppendPosition(), appendBlobRequestConditions.getIfModifiedSince(), appendBlobRequestConditions.getIfUnmodifiedSince(), appendBlobRequestConditions.getIfMatch(), appendBlobRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), context).map(rb -> {
            AppendBlobAppendBlockHeaders hd = (AppendBlobAppendBlockHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getBlobAppendOffset(), hd.getBlobCommittedBlockCount());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<AppendBlobItem> appendBlockFromUrl(String sourceUrl, BlobRange sourceRange) {
        try {
            return this.appendBlockFromUrlWithResponse(sourceUrl, sourceRange, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<AppendBlobItem>> appendBlockFromUrlWithResponse(String sourceUrl, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.appendBlockFromUrlWithResponse(sourceUrl, sourceRange, sourceContentMD5, destRequestConditions, sourceRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> appendBlockFromUrlWithResponse(String sourceUrl, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobRequestConditions destRequestConditions, RequestConditions sourceRequestConditions, Context context) {
        URL url;
        sourceRange = sourceRange == null ? new BlobRange(0L) : sourceRange;
        destRequestConditions = destRequestConditions == null ? new AppendBlobRequestConditions() : destRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new RequestConditions() : sourceRequestConditions;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        return this.azureBlobStorage.appendBlobs().appendBlockFromUrlWithRestResponseAsync(null, null, url, 0L, sourceRange.toString(), sourceContentMD5, null, null, null, destRequestConditions.getLeaseId(), destRequestConditions.getMaxSize(), destRequestConditions.getAppendPosition(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), context).map(rb -> {
            AppendBlobAppendBlockFromUrlHeaders hd = (AppendBlobAppendBlockFromUrlHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getBlobAppendOffset(), hd.getBlobCommittedBlockCount());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }
}

