/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import java.time.OffsetDateTime;

public class PageBlobItem {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final byte[] contentMd5;
    private final Boolean isServerEncrypted;
    private final String encryptionKeySha256;
    private final Long blobSequenceNumber;

    public PageBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, Boolean isServerEncrypted, String encryptionKeySha256, Long blobSequenceNumber) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.blobSequenceNumber = blobSequenceNumber;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }
}

