/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import java.time.OffsetDateTime;

public class BlockBlobItem {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final byte[] contentMd5;
    private final Boolean isServerEncrypted;
    private final String encryptionKeySha256;

    public BlockBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }
}

