/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import java.time.OffsetDateTime;

public class AppendBlobItem {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final byte[] contentMd5;
    private final boolean isServerEncrypted;
    private final String encryptionKeySha256;
    private final String blobAppendOffset;
    private final Integer blobCommittedBlockCount;

    public AppendBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String blobAppendOffset, Integer blobCommittedBlockCount) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.blobAppendOffset = blobAppendOffset;
        this.blobCommittedBlockCount = blobCommittedBlockCount;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public String getBlobAppendOffset() {
        return this.blobAppendOffset;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }
}

