/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.PublicAccessType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Container-GetProperties-Headers")
public final class ContainerGetPropertiesHeaders {
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-blob-public-access")
    private PublicAccessType blobPublicAccess;
    @JsonProperty(value="x-ms-has-immutability-policy")
    private Boolean hasImmutabilityPolicy;
    @JsonProperty(value="x-ms-has-legal-hold")
    private Boolean hasLegalHold;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ContainerGetPropertiesHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ContainerGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ContainerGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public ContainerGetPropertiesHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public ContainerGetPropertiesHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public ContainerGetPropertiesHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public ContainerGetPropertiesHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ContainerGetPropertiesHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ContainerGetPropertiesHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public ContainerGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public PublicAccessType getBlobPublicAccess() {
        return this.blobPublicAccess;
    }

    public ContainerGetPropertiesHeaders setBlobPublicAccess(PublicAccessType blobPublicAccess) {
        this.blobPublicAccess = blobPublicAccess;
        return this;
    }

    public Boolean isHasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public ContainerGetPropertiesHeaders setHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    public Boolean isHasLegalHold() {
        return this.hasLegalHold;
    }

    public ContainerGetPropertiesHeaders setHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ContainerGetPropertiesHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

