/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesResponse;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalResponse;
import com.azure.storage.blob.implementation.models.PageBlobsCreateResponse;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesDiffResponse;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesResponse;
import com.azure.storage.blob.implementation.models.PageBlobsResizeResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesFromURLResponse;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesResponse;
import com.azure.storage.blob.implementation.models.PremiumPageBlobAccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.SequenceNumberActionType;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PageBlobsImpl {
    private PageBlobsService service;
    private AzureBlobStorageImpl client;

    public PageBlobsImpl(AzureBlobStorageImpl client) {
        this.service = (PageBlobsService)RestProxy.create(PageBlobsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<PageBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, long blobContentLength, Context context) {
        Integer timeout = null;
        PremiumPageBlobAccessTier tier = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        Long blobSequenceNumber = 0L;
        String requestId = null;
        String blobType = "PageBlob";
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String cacheControl = null;
        String contentDisposition = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String contentMd5Converted = null;
        return this.service.create(containerName, blob, this.client.getUrl(), timeout, contentLength, tier, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, blobContentLength, blobSequenceNumber, this.client.getVersion(), requestId, "PageBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long blobSequenceNumber, String requestId, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, Context context) {
        String blobType = "PageBlob";
        String contentType = null;
        if (blobHttpHeaders != null) {
            contentType = blobHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (blobHttpHeaders != null) {
            contentEncoding = blobHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (blobHttpHeaders != null) {
            contentLanguage = blobHttpHeaders.getContentLanguage();
        }
        byte[] contentMd5 = null;
        if (blobHttpHeaders != null) {
            contentMd5 = blobHttpHeaders.getContentMd5();
        }
        String cacheControl = null;
        if (blobHttpHeaders != null) {
            cacheControl = blobHttpHeaders.getCacheControl();
        }
        String contentDisposition = null;
        if (blobHttpHeaders != null) {
            contentDisposition = blobHttpHeaders.getContentDisposition();
        }
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.create(containerName, blob, this.client.getUrl(), timeout, contentLength, tier, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, blobContentLength, blobSequenceNumber, this.client.getVersion(), requestId, "PageBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPagesWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, Context context) {
        Integer timeout = null;
        String range = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "page";
        String pageWrite = "update";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String transactionalContentMD5Converted = null;
        String transactionalContentCrc64Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.uploadPages(containerName, blob, this.client.getUrl(), body, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "page", "update", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPagesWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, CpkInfo cpkInfo, Context context) {
        String comp = "page";
        String pageWrite = "update";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.uploadPages(containerName, blob, this.client.getUrl(), body, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "page", "update", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsClearPagesResponse> clearPagesWithRestResponseAsync(String containerName, String blob, long contentLength, Context context) {
        Integer timeout = null;
        String range = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "page";
        String pageWrite = "clear";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.clearPages(containerName, blob, this.client.getUrl(), contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "page", "clear", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsClearPagesResponse> clearPagesWithRestResponseAsync(String containerName, String blob, long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, CpkInfo cpkInfo, Context context) {
        String comp = "page";
        String pageWrite = "clear";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.clearPages(containerName, blob, this.client.getUrl(), contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "page", "clear", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURLWithRestResponseAsync(String containerName, String blob, URL sourceUrl, String sourceRange, long contentLength, String range, Context context) {
        Integer timeout = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String requestId = null;
        String comp = "page";
        String pageWrite = "update";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String sourceContentMD5Converted = null;
        String sourceContentcrc64Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.uploadPagesFromURL(containerName, blob, this.client.getUrl(), sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "page", "update", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURLWithRestResponseAsync(String containerName, String blob, URL sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, CpkInfo cpkInfo, Context context) {
        String comp = "page";
        String pageWrite = "update";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString((byte[])sourceContentcrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.uploadPagesFromURL(containerName, blob, this.client.getUrl(), sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "page", "update", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRangesWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        Integer timeout = null;
        String range = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "pagelist";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getPageRanges(containerName, blob, this.client.getUrl(), snapshot, timeout, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "pagelist", context);
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRangesWithRestResponseAsync(String containerName, String blob, String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, Context context) {
        String comp = "pagelist";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRanges(containerName, blob, this.client.getUrl(), snapshot, timeout, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "pagelist", context);
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        Integer timeout = null;
        String prevsnapshot = null;
        String range = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "pagelist";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getPageRangesDiff(containerName, blob, this.client.getUrl(), snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "pagelist", context);
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithRestResponseAsync(String containerName, String blob, String snapshot, Integer timeout, String prevsnapshot, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, Context context) {
        String comp = "pagelist";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRangesDiff(containerName, blob, this.client.getUrl(), snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "pagelist", context);
    }

    public Mono<PageBlobsResizeResponse> resizeWithRestResponseAsync(String containerName, String blob, long blobContentLength, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "properties";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.resize(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, blobContentLength, this.client.getVersion(), requestId, "properties", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsResizeResponse> resizeWithRestResponseAsync(String containerName, String blob, long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, CpkInfo cpkInfo, Context context) {
        String comp = "properties";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.resize(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, blobContentLength, this.client.getVersion(), requestId, "properties", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithRestResponseAsync(String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        Long blobSequenceNumber = 0L;
        String requestId = null;
        String comp = "properties";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.updateSequenceNumber(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, "properties", context);
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithRestResponseAsync(String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long blobSequenceNumber, String requestId, Context context) {
        String comp = "properties";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateSequenceNumber(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, "properties", context);
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncrementalWithRestResponseAsync(String containerName, String blob, URL copySource, Context context) {
        Integer timeout = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String comp = "incrementalcopy";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.copyIncremental(containerName, blob, this.client.getUrl(), timeout, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, copySource, this.client.getVersion(), requestId, "incrementalcopy", context);
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncrementalWithRestResponseAsync(String containerName, String blob, URL copySource, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, Context context) {
        String comp = "incrementalcopy";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.copyIncremental(containerName, blob, this.client.getUrl(), timeout, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, copySource, this.client.getVersion(), requestId, "incrementalcopy", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStoragePageBlobs")
    private static interface PageBlobsService {
        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsCreateResponse> create(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="x-ms-access-tier") PremiumPageBlobAccessTier var7, @HeaderParam(value="x-ms-meta-") Map<String, String> var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="x-ms-blob-content-length") long var14, @HeaderParam(value="x-ms-blob-sequence-number") Long var16, @HeaderParam(value="x-ms-version") String var17, @HeaderParam(value="x-ms-client-request-id") String var18, @HeaderParam(value="x-ms-blob-type") String var19, @HeaderParam(value="x-ms-blob-content-type") String var20, @HeaderParam(value="x-ms-blob-content-encoding") String var21, @HeaderParam(value="x-ms-blob-content-language") String var22, @HeaderParam(value="x-ms-blob-content-md5") String var23, @HeaderParam(value="x-ms-blob-cache-control") String var24, @HeaderParam(value="x-ms-blob-content-disposition") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, Context var29);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUploadPagesResponse> uploadPages(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-MD5") String var7, @HeaderParam(value="x-ms-content-crc64") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-range") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-if-sequence-number-le") Long var12, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var13, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var14, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Match") String var17, @HeaderParam(value="If-None-Match") String var18, @HeaderParam(value="x-ms-version") String var19, @HeaderParam(value="x-ms-client-request-id") String var20, @QueryParam(value="comp") String var21, @HeaderParam(value="x-ms-page-write") String var22, @HeaderParam(value="x-ms-encryption-key") String var23, @HeaderParam(value="x-ms-encryption-key-sha256") String var24, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var25, Context var26);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsClearPagesResponse> clearPages(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="Content-Length") long var4, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-if-sequence-number-le") Long var9, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var10, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @QueryParam(value="comp") String var18, @HeaderParam(value="x-ms-page-write") String var19, @HeaderParam(value="x-ms-encryption-key") String var20, @HeaderParam(value="x-ms-encryption-key-sha256") String var21, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var22, Context var23);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-copy-source") URL var4, @HeaderParam(value="x-ms-source-range") String var5, @HeaderParam(value="x-ms-source-content-md5") String var6, @HeaderParam(value="x-ms-source-content-crc64") String var7, @HeaderParam(value="Content-Length") long var8, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-range") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-if-sequence-number-le") Long var13, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var14, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var15, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var17, @HeaderParam(value="If-Match") String var18, @HeaderParam(value="If-None-Match") String var19, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var20, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var21, @HeaderParam(value="x-ms-source-if-match") String var22, @HeaderParam(value="x-ms-source-if-none-match") String var23, @HeaderParam(value="x-ms-version") String var24, @HeaderParam(value="x-ms-client-request-id") String var25, @QueryParam(value="comp") String var26, @HeaderParam(value="x-ms-page-write") String var27, @HeaderParam(value="x-ms-encryption-key") String var28, @HeaderParam(value="x-ms-encryption-key-sha256") String var29, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var30, Context var31);

        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsGetPageRangesResponse> getPageRanges(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, Context var15);

        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="prevsnapshot") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @QueryParam(value="comp") String var15, Context var16);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsResizeResponse> resize(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-blob-content-length") long var10, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-encryption-key") String var15, @HeaderParam(value="x-ms-encryption-key-sha256") String var16, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var17, Context var18);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-sequence-number-action") SequenceNumberActionType var10, @HeaderParam(value="x-ms-blob-sequence-number") Long var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, Context var15);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<PageBlobsCopyIncrementalResponse> copyIncremental(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="x-ms-copy-source") URL var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @QueryParam(value="comp") String var12, Context var13);
    }
}

