/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.PathRenameMode;

@ServiceClientBuilder(serviceClients={AzureBlobStorageImpl.class})
public final class AzureBlobStorageBuilder {
    private String url;
    private String version;
    private PathRenameMode pathRenameMode;
    private HttpPipeline pipeline;

    public AzureBlobStorageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureBlobStorageBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureBlobStorageBuilder pathRenameMode(PathRenameMode pathRenameMode) {
        this.pathRenameMode = pathRenameMode;
        return this;
    }

    public AzureBlobStorageBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureBlobStorageImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        AzureBlobStorageImpl client = new AzureBlobStorageImpl(this.pipeline);
        if (this.url != null) {
            client.setUrl(this.url);
        }
        if (this.version != null) {
            client.setVersion(this.version);
        } else {
            client.setVersion("2019-02-02");
        }
        if (this.pathRenameMode != null) {
            client.setPathRenameMode(this.pathRenameMode);
        }
        return client;
    }
}

