/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.ServiceGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ServiceListBlobContainersSegmentHeaders;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentResponse;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class BlobServiceAsyncClient {
    private final ClientLogger logger = new ClientLogger(BlobServiceAsyncClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final boolean anonymousAccess;

    BlobServiceAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, CpkInfo customerProvidedKey, boolean anonymousAccess) {
        this.azureBlobStorage = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).build();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.customerProvidedKey = customerProvidedKey;
        this.anonymousAccess = anonymousAccess;
    }

    public BlobContainerAsyncClient getBlobContainerAsyncClient(String containerName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)containerName)) {
            containerName = "$root";
        }
        return new BlobContainerAsyncClient(this.getHttpPipeline(), StorageImplUtils.appendToUrlPath((String)this.getAccountUrl(), (String)containerName).toString(), this.getServiceVersion(), this.getAccountName(), containerName, this.customerProvidedKey);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public Mono<BlobContainerAsyncClient> createBlobContainer(String containerName) {
        try {
            return this.createBlobContainerWithResponse(containerName, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return FluxUtil.withContext(context -> this.createBlobContainerWithResponse(containerName, metadata, accessType, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        this.throwOnAnonymousAccess();
        BlobContainerAsyncClient blobContainerAsyncClient = this.getBlobContainerAsyncClient(containerName);
        return blobContainerAsyncClient.createWithResponse(metadata, accessType, context).map(response -> new SimpleResponse(response, (Object)blobContainerAsyncClient));
    }

    public Mono<Void> deleteBlobContainer(String containerName) {
        try {
            return this.deleteBlobContainerWithResponse(containerName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteBlobContainerWithResponse(containerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName, Context context) {
        this.throwOnAnonymousAccess();
        return this.getBlobContainerAsyncClient(containerName).deleteWithResponse(null, context);
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    public PagedFlux<BlobContainerItem> listBlobContainers() {
        try {
            return this.listBlobContainers(new ListBlobContainersOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options) {
        try {
            return this.listBlobContainersWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<BlobContainerItem> listBlobContainersWithOptionalTimeout(ListBlobContainersOptions options, Duration timeout) {
        this.throwOnAnonymousAccess();
        Function<String, Mono> func = marker -> this.listBlobContainersSegment((String)marker, options, timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getBlobContainerItems(), response.getValue().getNextMarker(), (Object)((ServiceListBlobContainersSegmentHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)func.apply(null), func);
    }

    private Mono<ServicesListBlobContainersSegmentResponse> listBlobContainersSegment(String marker, ListBlobContainersOptions options, Duration timeout) {
        options = options == null ? new ListBlobContainersOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.services().listBlobContainersSegmentWithRestResponseAsync(options.getPrefix(), marker, options.getMaxResultsPerPage(), options.getDetails().toIncludeType(), null, null, Context.NONE), (Duration)timeout);
    }

    public Mono<BlobServiceProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobServiceProperties>> getPropertiesWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.services().getPropertiesWithRestResponseAsync(null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)rb.getValue()));
    }

    public Mono<Void> setProperties(BlobServiceProperties properties) {
        try {
            return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties, Context context) {
        this.throwOnAnonymousAccess();
        BlobServiceProperties finalProperties = null;
        if (properties != null) {
            finalProperties = new BlobServiceProperties();
            finalProperties.setLogging(properties.getLogging());
            if (finalProperties.getLogging() != null) {
                StorageImplUtils.assertNotNull((String)"Logging Version", (Object)finalProperties.getLogging().getVersion());
                this.validateRetentionPolicy(finalProperties.getLogging().getRetentionPolicy(), "Logging Retention Policy");
            }
            finalProperties.setHourMetrics(properties.getHourMetrics());
            if (finalProperties.getHourMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"HourMetrics Version", (Object)finalProperties.getHourMetrics().getVersion());
                this.validateRetentionPolicy(finalProperties.getHourMetrics().getRetentionPolicy(), "HourMetrics Retention Policy");
                if (finalProperties.getHourMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"HourMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            finalProperties.setMinuteMetrics(properties.getMinuteMetrics());
            if (finalProperties.getMinuteMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"MinuteMetrics Version", (Object)finalProperties.getMinuteMetrics().getVersion());
                this.validateRetentionPolicy(finalProperties.getMinuteMetrics().getRetentionPolicy(), "MinuteMetrics Retention Policy");
                if (finalProperties.getMinuteMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"MinuteMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            if (properties.getCors() != null) {
                ArrayList<BlobCorsRule> corsRules = new ArrayList<BlobCorsRule>();
                for (BlobCorsRule rule : properties.getCors()) {
                    corsRules.add(this.validatedCorsRule(rule));
                }
                finalProperties.setCors(corsRules);
            }
            finalProperties.setDefaultServiceVersion(properties.getDefaultServiceVersion());
            finalProperties.setDeleteRetentionPolicy(properties.getDeleteRetentionPolicy());
            this.validateRetentionPolicy(finalProperties.getDeleteRetentionPolicy(), "DeleteRetentionPolicy Days");
            finalProperties.setStaticWebsite(properties.getStaticWebsite());
        }
        return this.azureBlobStorage.services().setPropertiesWithRestResponseAsync(finalProperties, null, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    private BlobCorsRule validatedCorsRule(BlobCorsRule originalRule) {
        if (originalRule == null) {
            return null;
        }
        BlobCorsRule validRule = new BlobCorsRule();
        validRule.setAllowedHeaders(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedHeaders()));
        validRule.setAllowedMethods(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedMethods()));
        validRule.setAllowedOrigins(StorageImplUtils.emptyIfNull((String)originalRule.getAllowedOrigins()));
        validRule.setExposedHeaders(StorageImplUtils.emptyIfNull((String)originalRule.getExposedHeaders()));
        validRule.setMaxAgeInSeconds(originalRule.getMaxAgeInSeconds());
        return validRule;
    }

    private void validateRetentionPolicy(BlobRetentionPolicy retentionPolicy, String policyName) {
        if (retentionPolicy == null) {
            return;
        }
        if (retentionPolicy.isEnabled()) {
            StorageImplUtils.assertInBounds((String)policyName, (long)retentionPolicy.getDays().intValue(), (long)1L, (long)365L);
        }
    }

    public Mono<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return FluxUtil.withContext(context -> this.getUserDelegationKeyWithResponse(start, expiry, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return FluxUtil.withContext(context -> this.getUserDelegationKeyWithResponse(start, expiry, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Context context) {
        StorageImplUtils.assertNotNull((String)"expiry", (Object)expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("`start` must be null or a datetime before `expiry`."));
        }
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.services().getUserDelegationKeyWithRestResponseAsync(new KeyInfo().setStart(start == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(start)).setExpiry(Constants.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)rb.getValue()));
    }

    public Mono<BlobServiceStatistics> getStatistics() {
        try {
            return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(this::getStatisticsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.services().getStatisticsWithRestResponseAsync(null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)rb.getValue()));
    }

    public Mono<StorageAccountInfo> getAccountInfo() {
        try {
            return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.services().getAccountInfoWithRestResponseAsync(context).map(rb -> {
            ServiceGetAccountInfoHeaders hd = (ServiceGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse((Response)rb, (Object)new StorageAccountInfo(hd.getSkuName(), hd.getAccountKind()));
        });
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        this.throwOnAnonymousAccess();
        return new AccountSasImplUtil(accountSasSignatureValues).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    private void throwOnAnonymousAccess() {
        if (this.anonymousAccess) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service client cannot be accessed without credentials"));
        }
    }
}

