/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

public class BlobClient
extends BlobClientBase {
    private final ClientLogger logger = new ClientLogger(BlobClient.class);
    public static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final int BLOB_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final int BLOB_DEFAULT_HTBB_UPLOAD_BLOCK_SIZE = 0x800000;
    private final BlobAsyncClient client;

    protected BlobClient(BlobAsyncClient client) {
        super(client);
        this.client = client;
    }

    @Override
    public BlobClient getSnapshotClient(String snapshot) {
        return new BlobClient(this.client.getSnapshotClient(snapshot));
    }

    public AppendBlobClient getAppendBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildAppendBlobClient();
    }

    public BlockBlobClient getBlockBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildBlockBlobClient();
    }

    public PageBlobClient getPageBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildPageBlobClient();
    }

    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    public void uploadFromFile(String filePath, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.client.uploadInBlocks(filePath, 0x10000000) && this.exists().booleanValue()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        this.uploadFromFile(filePath, null, null, null, null, requestConditions, null);
    }

    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) {
        Mono<Void> upload = this.client.uploadFromFile(filePath, parallelTransferOptions, headers, metadata, tier, requestConditions);
        try {
            StorageImplUtils.blockWithOptionalTimeout(upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)e);
        }
    }
}

