// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import java.util.Collections;
import java.util.Map;

/**
 * Blob info from a Filter Blobs API call.
 */
public final class TaggedBlobItem {

    /**
     * Constructor to create a new TaggedBlobItem
     * @param containerName The container name
     * @param name The blob name
     */
    public TaggedBlobItem(String containerName, String name) {
        this(containerName, name, Collections.emptyMap());
    }

    /**
     * Constructor to create a new TaggedBlobItem
     * @param containerName The container name
     * @param name The blob name
     * @param tags The blob tags
     */
    public TaggedBlobItem(String containerName, String name, Map<String, String> tags) {
        this.name = name;
        this.containerName = containerName;
        this.tags = tags;
    }

    /*
     * The name property.
     */
    private final String name;

    /*
     * The containerName property.
     */
    private final String containerName;

    private final Map<String, String> tags;

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the containerName property: The containerName property.
     *
     * @return the containerName value.
     */
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Get the tags property: The tags property.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }
}
