/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobContainersSegment;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.FilterBlobsIncludeItem;
import com.azure.storage.blob.implementation.models.ServicesFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetStatisticsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetUserDelegationKeyHeaders;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentHeaders;
import com.azure.storage.blob.implementation.models.ServicesListBlobContainersSegmentNextHeaders;
import com.azure.storage.blob.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ServicesSubmitBatchHeaders;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import com.azure.storage.blob.models.UserDelegationKey;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureBlobStorageImpl client;

    ServicesImpl(AzureBlobStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithResponseAsync(blobServiceProperties, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        return this.setPropertiesWithResponseAsync(blobServiceProperties, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(BlobServiceProperties blobServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, blobServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((BlobServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getPropertiesAsync(Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((BlobServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((BlobServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatisticsAsync(Integer timeout, String requestId, Context context) {
        return this.getStatisticsWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((BlobServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegment(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (Object)((ServicesListBlobContainersSegmentHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobContainersSegment(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (Object)((ServicesListBlobContainersSegmentHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedFlux(() -> this.listBlobContainersSegmentSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedFlux(() -> this.listBlobContainersSegmentSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String listBlobContainersIncludeTypeConverted = listBlobContainersIncludeType == null ? null : listBlobContainersIncludeType.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobContainersSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, listBlobContainersIncludeTypeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId) {
        return new PagedFlux(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainersSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListBlobContainersIncludeType> listBlobContainersIncludeType, Integer timeout, String requestId, Context context) {
        return new PagedFlux(() -> this.listBlobContainersSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, listBlobContainersIncludeType, timeout, requestId, context), nextLink -> this.listBlobContainersSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKeyWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getUserDelegationKey(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKeyWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return this.service.getUserDelegationKey(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKeyAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        return this.getUserDelegationKeyWithResponseAsync(keyInfo, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((UserDelegationKey)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKeyAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        return this.getUserDelegationKeyWithResponseAsync(keyInfo, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((UserDelegationKey)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeadersWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getUserDelegationKeyNoCustomHeaders(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeadersWithResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "userdelegationkey";
        String accept = "application/xml";
        return this.service.getUserDelegationKeyNoCustomHeaders(this.client.getUrl(), "service", "userdelegationkey", timeout, this.client.getVersion(), requestId, keyInfo, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync() {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccountInfo(this.client.getUrl(), "account", "properties", this.client.getVersion(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync(Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfo(this.client.getUrl(), "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync() {
        return this.getAccountInfoWithResponseAsync().flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(Context context) {
        return this.getAccountInfoWithResponseAsync(context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync() {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccountInfoNoCustomHeaders(this.client.getUrl(), "account", "properties", this.client.getVersion(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfoNoCustomHeaders(this.client.getUrl(), "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(contentLength, multipartContentType, body, timeout, requestId, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.filterBlobs(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.filterBlobs(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        return this.filterBlobsWithResponseAsync(timeout, requestId, where, marker, maxresults, include).flatMap(res -> Mono.justOrEmpty((Object)((FilterBlobSegment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        return this.filterBlobsWithResponseAsync(timeout, requestId, where, marker, maxresults, include, context).flatMap(res -> Mono.justOrEmpty((Object)((FilterBlobSegment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.filterBlobsNoCustomHeaders(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        String comp = "blobs";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.filterBlobsNoCustomHeaders(this.client.getUrl(), "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (Object)((ServicesListBlobContainersSegmentNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listBlobContainersSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), (Object)((ServicesListBlobContainersSegmentNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listBlobContainersSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listBlobContainersSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BlobContainersSegment)res.getValue()).getBlobContainerItems(), ((BlobContainersSegment)res.getValue()).getNextMarker(), null));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageServ")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") BlobServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, BlobServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<BlobServiceProperties>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesGetStatisticsHeaders, BlobServiceStatistics>> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<BlobServiceStatistics>> getStatisticsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesListBlobContainersSegmentHeaders, BlobContainersSegment>> listBlobContainersSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<BlobContainersSegment>> listBlobContainersSegmentNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesGetUserDelegationKeyHeaders, UserDelegationKey>> getUserDelegationKey(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<UserDelegationKey>> getUserDelegationKeyNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") KeyInfo var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesGetAccountInfoHeaders, Void>> getAccountInfo(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> getAccountInfoNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") Flux<ByteBuffer> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") Flux<ByteBuffer> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="Content-Type") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @BodyParam(value="application/xml") BinaryData var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesFilterBlobsHeaders, FilterBlobSegment>> filterBlobs(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="where") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ServicesListBlobContainersSegmentNextHeaders, BlobContainersSegment>> listBlobContainersSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<BlobContainersSegment>> listBlobContainersSegmentNextNoCustomHeaders(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

