/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.util.StorageBlockingSink;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.common.StorageOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class BlobOutputStream
extends StorageOutputStream {
    private volatile boolean isClosed;

    BlobOutputStream(int writeThreshold) {
        super(writeThreshold);
    }

    static BlobOutputStream appendBlobOutputStream(AppendBlobAsyncClient client, AppendBlobRequestConditions appendBlobRequestConditions) {
        return new AppendBlobOutputStream(client, appendBlobRequestConditions);
    }

    public static BlobOutputStream blockBlobOutputStream(BlobAsyncClient client, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return BlobOutputStream.blockBlobOutputStream(client, parallelTransferOptions, headers, metadata, tier, requestConditions, Context.NONE);
    }

    public static BlobOutputStream blockBlobOutputStream(BlobAsyncClient client, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Context context) {
        return BlobOutputStream.blockBlobOutputStream(client, new BlockBlobOutputStreamOptions().setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), context);
    }

    public static BlobOutputStream blockBlobOutputStream(BlobAsyncClient client, BlockBlobOutputStreamOptions options, Context context) {
        options = options == null ? new BlockBlobOutputStreamOptions() : options;
        return new BlockBlobOutputStream(client, options.getParallelTransferOptions(), options.getHeaders(), options.getMetadata(), options.getTags(), options.getTier(), options.getRequestConditions(), context);
    }

    static BlobOutputStream pageBlobOutputStream(PageBlobAsyncClient client, PageRange pageRange, BlobRequestConditions requestConditions) {
        return new PageBlobOutputStream(client, pageRange, requestConditions);
    }

    abstract void commit();

    public synchronized void close() throws IOException {
        try {
            if (this.isClosed) {
                return;
            }
            this.checkStreamState();
            this.flush();
            try {
                this.commit();
            }
            catch (BlobStorageException e) {
                throw new IOException("The blob has not been committed. Data has not been persisted.", (Throwable)((Object)e));
            }
            if (this.lastError != null) {
                throw this.lastError;
            }
        }
        finally {
            this.lastError = new IOException("Stream is already closed.");
            this.isClosed = true;
        }
    }

    private static final class AppendBlobOutputStream
    extends BlobOutputStream {
        private static final String INVALID_BLOCK_SIZE = "Block data should not exceed BlockBlobURL.MAX_STAGE_BLOCK_BYTES";
        private final AppendBlobRequestConditions appendBlobRequestConditions;
        private final AppendBlobAsyncClient client;

        private AppendBlobOutputStream(AppendBlobAsyncClient client, AppendBlobRequestConditions appendBlobRequestConditions) {
            super(client.getServiceVersion().ordinal() < BlobServiceVersion.V2022_11_02.ordinal() ? 0x400000 : 0x6400000);
            this.client = client;
            AppendBlobRequestConditions appendBlobRequestConditions2 = this.appendBlobRequestConditions = appendBlobRequestConditions == null ? new AppendBlobRequestConditions() : appendBlobRequestConditions;
            if (this.appendBlobRequestConditions.getAppendPosition() == null) {
                this.appendBlobRequestConditions.setAppendPosition(((BlobProperties)client.getProperties().block()).getBlobSize());
            }
        }

        private Mono<Void> appendBlock(Flux<ByteBuffer> blockData, long writeLength) {
            long newAppendOffset = this.appendBlobRequestConditions.getAppendPosition() + writeLength;
            return this.client.appendBlockWithResponse(blockData, writeLength, null, this.appendBlobRequestConditions).doOnNext(ignored -> this.appendBlobRequestConditions.setAppendPosition(newAppendOffset)).then().onErrorResume(t -> t instanceof IOException || t instanceof BlobStorageException, e -> {
                this.lastError = new IOException((Throwable)e);
                return Mono.empty();
            });
        }

        protected Mono<Void> dispatchWrite(byte[] data, int writeLength, long offset) {
            if (writeLength == 0) {
                return Mono.empty();
            }
            if (this.appendBlobRequestConditions.getMaxSize() != null && this.appendBlobRequestConditions.getAppendPosition() > this.appendBlobRequestConditions.getMaxSize()) {
                this.lastError = new IOException(INVALID_BLOCK_SIZE);
                return Mono.error((Throwable)this.lastError);
            }
            return this.appendBlock((Flux<ByteBuffer>)Mono.fromCallable(() -> ByteBuffer.wrap(data, (int)offset, writeLength)).flux(), writeLength);
        }

        @Override
        void commit() {
        }
    }

    private static final class BlockBlobOutputStream
    extends BlobOutputStream {
        private final Lock lock;
        private final Condition transferComplete;
        private final StorageBlockingSink sink;
        boolean complete;

        private BlockBlobOutputStream(BlobAsyncClient client, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, BlobRequestConditions requestConditions, Context context) {
            super(Integer.MAX_VALUE);
            context = context == null || context.equals(Context.NONE) ? null : context;
            this.lock = new ReentrantLock();
            this.transferComplete = this.lock.newCondition();
            this.sink = new StorageBlockingSink();
            Flux<ByteBuffer> body = this.sink.asFlux();
            client.uploadWithResponse(new BlobParallelUploadOptions(body).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTags(tags).setTier(tier).setRequestConditions(requestConditions)).onErrorResume(e -> {
                this.lastError = e instanceof IOException ? (IOException)e : new IOException((Throwable)e);
                return Mono.empty();
            }).doFinally(signalType -> {
                this.lock.lock();
                try {
                    this.complete = true;
                    this.transferComplete.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }).contextWrite((ContextView)FluxUtil.toReactorContext((Context)context)).subscribe();
        }

        @Override
        void commit() {
            this.lock.lock();
            try {
                this.sink.emitCompleteOrThrow();
                while (!this.complete) {
                    this.transferComplete.await();
                }
            }
            catch (InterruptedException e) {
                this.lastError = new IOException(e.getMessage());
            }
            catch (Exception e) {
                this.lastError = new IOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void writeInternal(byte[] data, int offset, int length) {
            this.checkStreamState();
            byte[] buffer = new byte[length];
            System.arraycopy(data, offset, buffer, 0, length);
            try {
                this.sink.emitNext(ByteBuffer.wrap(buffer));
            }
            catch (Exception e) {
                this.lastError = new IOException(e);
            }
        }

        protected Mono<Void> dispatchWrite(byte[] data, int writeLength, long offset) {
            return Mono.empty();
        }
    }

    private static final class PageBlobOutputStream
    extends BlobOutputStream {
        private static final String INVALID_NUMBER_OF_BYTES_IN_THE_BUFFER = "Page data must be a multiple of 512 bytes. Buffer currently contains %d bytes.";
        private static final ClientLogger LOGGER = new ClientLogger(PageBlobOutputStream.class);
        private final PageBlobAsyncClient client;
        private final PageBlobRequestConditions pageBlobRequestConditions;
        private final PageRange pageRange;

        private PageBlobOutputStream(PageBlobAsyncClient client, PageRange pageRange, BlobRequestConditions blobRequestConditions) {
            super(0x400000);
            this.client = client;
            this.pageRange = pageRange;
            this.pageBlobRequestConditions = blobRequestConditions != null ? new PageBlobRequestConditions().setLeaseId(blobRequestConditions.getLeaseId()).setIfMatch(blobRequestConditions.getIfMatch()).setIfNoneMatch(blobRequestConditions.getIfNoneMatch()).setIfModifiedSince(blobRequestConditions.getIfModifiedSince()).setIfUnmodifiedSince(blobRequestConditions.getIfUnmodifiedSince()) : null;
        }

        private Mono<Void> writePages(Flux<ByteBuffer> pageData, int length, long offset) {
            return this.client.uploadPagesWithResponse(new PageRange().setStart(offset).setEnd(offset + (long)length - 1L), pageData, null, this.pageBlobRequestConditions).then().onErrorResume(BlobStorageException.class, e -> {
                this.lastError = new IOException((Throwable)((Object)e));
                return Mono.empty();
            });
        }

        protected Mono<Void> dispatchWrite(byte[] data, int writeLength, long offset) {
            if (writeLength == 0) {
                return Mono.empty();
            }
            if (writeLength % 512 != 0) {
                return Mono.error((Throwable)new IOException(String.format(INVALID_NUMBER_OF_BYTES_IN_THE_BUFFER, writeLength)));
            }
            long pageOffset = this.pageRange.getStart();
            if (pageOffset + (long)writeLength - 1L > this.pageRange.getEnd()) {
                throw LOGGER.logExceptionAsError(new RuntimeException("The input data length is larger than the page range."));
            }
            this.pageRange.setStart(this.pageRange.getStart() + (long)writeLength);
            return this.writePages((Flux<ByteBuffer>)Mono.fromCallable(() -> ByteBuffer.wrap(data, (int)offset, writeLength)).flux(), writeLength, pageOffset);
        }

        @Override
        void commit() {
        }
    }
}

