// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for ListBlobContainersIncludeType. */
public enum ListBlobContainersIncludeType {
    /** Enum value metadata. */
    METADATA("metadata"),

    /** Enum value deleted. */
    DELETED("deleted"),

    /** Enum value system. */
    SYSTEM("system");

    /** The actual serialized value for a ListBlobContainersIncludeType instance. */
    private final String value;

    ListBlobContainersIncludeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ListBlobContainersIncludeType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ListBlobContainersIncludeType object, or null if unable to parse.
     */
    @JsonCreator
    public static ListBlobContainersIncludeType fromString(String value) {
        if (value == null) {
            return null;
        }
        ListBlobContainersIncludeType[] items = ListBlobContainersIncludeType.values();
        for (ListBlobContainersIncludeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
