/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.sas;

import java.util.Locale;

public final class BlobContainerSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean deleteVersionPermission;
    private boolean listPermission;
    private boolean tagsPermission;
    private boolean movePermission;
    private boolean executePermission;

    public static BlobContainerSasPermission parse(String permString) {
        BlobContainerSasPermission permissions = new BlobContainerSasPermission();
        block12: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block12;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block12;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block12;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block12;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block12;
                }
                case 'x': {
                    permissions.deleteVersionPermission = true;
                    continue block12;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block12;
                }
                case 't': {
                    permissions.tagsPermission = true;
                    continue block12;
                }
                case 'm': {
                    permissions.movePermission = true;
                    continue block12;
                }
                case 'e': {
                    permissions.executePermission = true;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public BlobContainerSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public BlobContainerSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public BlobContainerSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public BlobContainerSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public BlobContainerSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasDeleteVersionPermission() {
        return this.deleteVersionPermission;
    }

    public BlobContainerSasPermission setDeleteVersionPermission(boolean hasDeleteVersionPermission) {
        this.deleteVersionPermission = hasDeleteVersionPermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public BlobContainerSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public boolean hasTagsPermission() {
        return this.tagsPermission;
    }

    public BlobContainerSasPermission setTagsPermission(boolean tagsPermission) {
        this.tagsPermission = tagsPermission;
        return this;
    }

    public boolean hasMovePermission() {
        return this.movePermission;
    }

    public BlobContainerSasPermission setMovePermission(boolean hasMovePermission) {
        this.movePermission = hasMovePermission;
        return this;
    }

    public boolean hasExecutePermission() {
        return this.executePermission;
    }

    public BlobContainerSasPermission setExecutePermission(boolean hasExecutePermission) {
        this.executePermission = hasExecutePermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.deleteVersionPermission) {
            builder.append('x');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        if (this.tagsPermission) {
            builder.append('t');
        }
        if (this.movePermission) {
            builder.append('m');
        }
        if (this.executePermission) {
            builder.append('e');
        }
        return builder.toString();
    }
}

