/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.DataLakeStorageErrorException;
import com.azure.storage.blob.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.blob.implementation.models.DirectoriesDeleteResponse;
import com.azure.storage.blob.implementation.models.DirectoriesGetAccessControlResponse;
import com.azure.storage.blob.implementation.models.DirectoriesRenameResponse;
import com.azure.storage.blob.implementation.models.DirectoriesSetAccessControlResponse;
import com.azure.storage.blob.implementation.models.DirectoryHttpHeaders;
import com.azure.storage.blob.models.PathRenameMode;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class DirectoriesImpl {
    private final DirectoriesService service;
    private final AzureBlobStorageImpl client;

    DirectoriesImpl(AzureBlobStorageImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesCreateResponse> createWithResponseAsync(String filesystem, String path, Integer timeout, String directoryProperties, String posixPermissions, String posixUmask, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, DirectoryHttpHeaders directoryHttpHeaders, Context context) {
        String resource = "directory";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (directoryHttpHeaders != null) {
            cacheControlInternal = directoryHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (directoryHttpHeaders != null) {
            contentTypeInternal = directoryHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (directoryHttpHeaders != null) {
            contentEncodingInternal = directoryHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (directoryHttpHeaders != null) {
            contentLanguageInternal = directoryHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (directoryHttpHeaders != null) {
            contentDispositionInternal = directoryHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.create(this.client.getUrl(), "directory", filesystem, path, timeout, directoryProperties, posixPermissions, posixUmask, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesRenameResponse> renameWithResponseAsync(String filesystem, String path, String renameSource, Integer timeout, String marker, String directoryProperties, String posixPermissions, String posixUmask, String leaseId, String sourceLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, DirectoryHttpHeaders directoryHttpHeaders, Context context) {
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (directoryHttpHeaders != null) {
            cacheControlInternal = directoryHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (directoryHttpHeaders != null) {
            contentTypeInternal = directoryHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (directoryHttpHeaders != null) {
            contentEncodingInternal = directoryHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (directoryHttpHeaders != null) {
            contentLanguageInternal = directoryHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (directoryHttpHeaders != null) {
            contentDispositionInternal = directoryHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.rename(this.client.getUrl(), filesystem, path, timeout, marker, this.client.getPathRenameMode(), renameSource, directoryProperties, posixPermissions, posixUmask, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, leaseId, sourceLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesDeleteResponse> deleteWithResponseAsync(String filesystem, String path, boolean recursiveDirectoryDelete, Integer timeout, String marker, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, Context context) {
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), filesystem, path, timeout, recursiveDirectoryDelete, marker, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesSetAccessControlResponse> setAccessControlWithResponseAsync(Integer timeout, String leaseId, String owner, String group, String posixPermissions, String posixAcl, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "setAccessControl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControl(this.client.getUrl(), "setAccessControl", timeout, leaseId, owner, group, posixPermissions, posixAcl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesGetAccessControlResponse> getAccessControlWithResponseAsync(Integer timeout, Boolean upn, String leaseId, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "getAccessControl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getAccessControl(this.client.getUrl(), "getAccessControl", timeout, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageDire")
    public static interface DirectoriesService {
        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectoriesCreateResponse> create(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @PathParam(value="filesystem") String var3, @PathParam(value="path") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-properties") String var6, @HeaderParam(value="x-ms-permissions") String var7, @HeaderParam(value="x-ms-umask") String var8, @HeaderParam(value="x-ms-cache-control") String var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-lease-id") String var14, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Match") String var17, @HeaderParam(value="If-None-Match") String var18, @HeaderParam(value="x-ms-version") String var19, @HeaderParam(value="x-ms-client-request-id") String var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectoriesRenameResponse> rename(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="continuation") String var5, @QueryParam(value="mode") PathRenameMode var6, @HeaderParam(value="x-ms-rename-source") String var7, @HeaderParam(value="x-ms-properties") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-umask") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-type") String var12, @HeaderParam(value="x-ms-content-encoding") String var13, @HeaderParam(value="x-ms-content-language") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-source-lease-id") String var17, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var18, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var22, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-source-if-match") String var24, @HeaderParam(value="x-ms-source-if-none-match") String var25, @HeaderParam(value="x-ms-version") String var26, @HeaderParam(value="x-ms-client-request-id") String var27, @HeaderParam(value="Accept") String var28, Context var29);

        @Delete(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectoriesDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="recursive") boolean var5, @QueryParam(value="continuation") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectoriesSetAccessControlResponse> setAccessControl(@HostParam(value="url") String var1, @QueryParam(value="action") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-owner") String var5, @HeaderParam(value="x-ms-group") String var6, @HeaderParam(value="x-ms-permissions") String var7, @HeaderParam(value="x-ms-acl") String var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Head(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectoriesGetAccessControlResponse> getAccessControl(@HostParam(value="url") String var1, @QueryParam(value="action") String var2, @QueryParam(value="timeout") Integer var3, @QueryParam(value="upn") Boolean var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="Accept") String var12, Context var13);
    }
}

