/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

final class EncryptedRegionInfo
implements JsonSerializable<EncryptedRegionInfo> {
    private long dataLength;
    private int nonceLength;

    EncryptedRegionInfo() {
    }

    EncryptedRegionInfo(long ciphertextLength, int nonceLength) {
        this.dataLength = ciphertextLength;
        this.nonceLength = nonceLength;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public int getNonceLength() {
        return this.nonceLength;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeNumberField("DataLength", (Number)this.dataLength).writeNumberField("NonceLength", (Number)this.nonceLength).writeEndObject();
    }

    public static EncryptedRegionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptedRegionInfo)jsonReader.readObject(reader -> {
            EncryptedRegionInfo encryptedRegionInfo = new EncryptedRegionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DataLength".equals(fieldName)) {
                    encryptedRegionInfo.dataLength = reader.getLong();
                    continue;
                }
                if ("NonceLength".equals(fieldName)) {
                    encryptedRegionInfo.nonceLength = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return encryptedRegionInfo;
        });
    }
}

