/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.DecryptorV1;
import com.azure.storage.blob.specialized.cryptography.DecryptorV2;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobRange;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.NoOpDecryptor;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class Decryptor {
    private static final ClientLogger LOGGER = new ClientLogger(Decryptor.class);
    protected AsyncKeyEncryptionKeyResolver keyResolver;
    protected AsyncKeyEncryptionKey keyWrapper;
    protected EncryptionData encryptionData;

    protected Decryptor(AsyncKeyEncryptionKeyResolver keyResolver, AsyncKeyEncryptionKey keyWrapper, EncryptionData encryptionData) {
        this.keyResolver = keyResolver;
        this.keyWrapper = keyWrapper;
        this.encryptionData = encryptionData;
    }

    protected Mono<byte[]> getKeyEncryptionKey() {
        Mono keyMono = this.keyResolver != null ? this.keyResolver.buildAsyncKeyEncryptionKey(this.encryptionData.getWrappedContentKey().getKeyId()).onErrorResume(NullPointerException.class, e -> {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }) : this.keyWrapper.getKeyId().flatMap(keyId -> {
            if (this.encryptionData.getWrappedContentKey().getKeyId().equals(keyId)) {
                return Mono.just((Object)this.keyWrapper);
            }
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)new IllegalArgumentException("Key mismatch. The key id stored on the service does not match the specified key.")));
        });
        return keyMono.flatMap(keyEncryptionKey -> keyEncryptionKey.unwrapKey(this.encryptionData.getWrappedContentKey().getAlgorithm(), this.encryptionData.getWrappedContentKey().getEncryptedKey()));
    }

    protected abstract Cipher getCipher(byte[] var1, byte[] var2, boolean var3) throws InvalidKeyException;

    abstract Flux<ByteBuffer> decrypt(Flux<ByteBuffer> var1, EncryptedBlobRange var2, boolean var3, String var4, AtomicLong var5, byte[] var6);

    static Decryptor getDecryptor(AsyncKeyEncryptionKeyResolver keyResolver, AsyncKeyEncryptionKey keyWrapper, EncryptionData encryptionData) {
        if (encryptionData == null) {
            return new NoOpDecryptor(keyResolver, keyWrapper, null);
        }
        switch (encryptionData.getEncryptionAgent().getProtocol()) {
            case "1.0": {
                return new DecryptorV1(keyResolver, keyWrapper, encryptionData);
            }
            case "2.0": 
            case "2.1": {
                return new DecryptorV2(keyResolver, keyWrapper, encryptionData);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Encryption protocol not recognized: " + encryptionData.getEncryptionAgent().getProtocol()));
    }
}

