/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import java.io.IOException;

final class EncryptionAgent
implements JsonSerializable<EncryptionAgent> {
    private String protocol;
    private EncryptionAlgorithm algorithm;

    EncryptionAgent() {
    }

    EncryptionAgent(String protocol, EncryptionAlgorithm algorithm) {
        this.protocol = protocol;
        this.algorithm = algorithm;
    }

    String getProtocol() {
        return this.protocol;
    }

    EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public EncryptionAgent setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public EncryptionAgent setAlgorithm(EncryptionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("Protocol", this.protocol).writeStringField("EncryptionAlgorithm", this.algorithm == null ? null : this.algorithm.toString()).writeEndObject();
    }

    public static EncryptionAgent fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionAgent)jsonReader.readObject(reader -> {
            EncryptionAgent encryptionAgent = new EncryptionAgent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Protocol".equals(fieldName)) {
                    encryptionAgent.protocol = reader.getString();
                    continue;
                }
                if ("EncryptionAlgorithm".equals(fieldName)) {
                    encryptionAgent.algorithm = EncryptionAlgorithm.valueOf(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return encryptionAgent;
        });
    }
}

