/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.storage.blob.changefeed.implementation.models.ChangefeedTypeValidator;
import com.azure.storage.blob.changefeed.implementation.models.InternalBlobChangefeedEventData;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEvent;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEventData;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEventType;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public class InternalBlobChangefeedEvent
implements BlobChangefeedEvent {
    private final String topic;
    private final String subject;
    private final BlobChangefeedEventType eventType;
    private final OffsetDateTime eventTime;
    private final String id;
    private final BlobChangefeedEventData data;
    private final Long dataVersion;
    private final String metadataVersion;

    public InternalBlobChangefeedEvent(String topic, String subject, BlobChangefeedEventType eventType, OffsetDateTime eventTime, String id, BlobChangefeedEventData data, Long dataVersion, String metadataVersion) {
        this.topic = topic;
        this.subject = subject;
        this.eventType = eventType;
        this.eventTime = eventTime;
        this.id = id;
        this.data = data;
        this.dataVersion = dataVersion;
        this.metadataVersion = metadataVersion;
    }

    public static InternalBlobChangefeedEvent fromRecord(Object record) {
        AvroSchema.checkType((String)"r", (Object)record, Map.class);
        Map r = (Map)record;
        if (!r.get("$record").equals("BlobChangeEvent")) {
            throw new IllegalArgumentException("Not a valid BlobChangefeedEvent.");
        }
        Object topic = r.get("topic");
        Object subject = r.get("subject");
        Object eventType = r.get("eventType");
        Object eventTime = r.get("eventTime");
        Object id = r.get("id");
        Object data = r.get("data");
        Object dataVersion = r.get("dataVersion");
        Object metadataVersion = r.get("metadataVersion");
        return new InternalBlobChangefeedEvent(ChangefeedTypeValidator.nullOr("topic", topic, String.class), ChangefeedTypeValidator.nullOr("subject", subject, String.class), ChangefeedTypeValidator.isNull(eventType) ? null : BlobChangefeedEventType.fromString(ChangefeedTypeValidator.nullOr("eventType", eventType, String.class)), ChangefeedTypeValidator.isNull(eventTime) ? null : OffsetDateTime.parse(Objects.requireNonNull(ChangefeedTypeValidator.nullOr("eventTime", eventTime, String.class))), ChangefeedTypeValidator.nullOr("id", id, String.class), ChangefeedTypeValidator.isNull(data) ? null : InternalBlobChangefeedEventData.fromRecord(data), ChangefeedTypeValidator.nullOr("dataVersion", dataVersion, Long.class), ChangefeedTypeValidator.nullOr("metadataVersion", metadataVersion, String.class));
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public BlobChangefeedEventType getEventType() {
        return this.eventType;
    }

    @Override
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BlobChangefeedEventData getData() {
        return this.data;
    }

    @Override
    public Long getDataVersion() {
        return this.dataVersion;
    }

    @Override
    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalBlobChangefeedEvent)) {
            return false;
        }
        InternalBlobChangefeedEvent event = (InternalBlobChangefeedEvent)o;
        return Objects.equals(this.getTopic(), event.getTopic()) && Objects.equals(this.getSubject(), event.getSubject()) && Objects.equals((Object)this.getEventType(), (Object)event.getEventType()) && Objects.equals(this.getEventTime(), event.getEventTime()) && Objects.equals(this.getId(), event.getId()) && Objects.equals(this.getData(), event.getData()) && Objects.equals(this.getDataVersion(), event.getDataVersion()) && Objects.equals(this.getMetadataVersion(), event.getMetadataVersion());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTopic(), this.getSubject(), this.getEventType(), this.getEventTime(), this.getId(), this.getData(), this.getDataVersion(), this.getMetadataVersion()});
    }

    public String toString() {
        return "BlobChangefeedEvent{topic='" + this.topic + '\'' + ", subject='" + this.subject + '\'' + ", eventType=" + (Object)((Object)this.eventType) + ", eventTime=" + this.eventTime + ", id='" + this.id + '\'' + ", data=" + this.data + ", dataVersion=" + this.dataVersion + ", metadataVersion='" + this.metadataVersion + '\'' + '}';
    }
}

