/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.storage.blob.changefeed.BlobChangefeedClientBuilder;
import com.azure.storage.blob.changefeed.BlobChangefeedPagedFlux;
import com.azure.storage.blob.changefeed.ChangefeedFactory;
import java.time.OffsetDateTime;

@ServiceClient(builder=BlobChangefeedClientBuilder.class, isAsync=true)
public class BlobChangefeedAsyncClient {
    final ChangefeedFactory changefeedFactory;

    BlobChangefeedAsyncClient(ChangefeedFactory changefeedFactory) {
        this.changefeedFactory = changefeedFactory;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedFlux getEvents() {
        return this.getEvents(null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedFlux getEvents(OffsetDateTime startTime, OffsetDateTime endTime) {
        return new BlobChangefeedPagedFlux(this.changefeedFactory, startTime, endTime);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedFlux getEvents(String cursor) {
        return new BlobChangefeedPagedFlux(this.changefeedFactory, cursor);
    }
}

