// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The secret list result.
 */
@Immutable
public final class SecretListResult implements JsonSerializable<SecretListResult> {
    /*
     * A response message containing a list of secrets in the key vault along with a link to the next page of secrets.
     */
    private List<SecretItem> value;

    /*
     * The URL to get the next set of secrets.
     */
    private String nextLink;

    /**
     * Creates an instance of SecretListResult class.
     */
    public SecretListResult() {
    }

    /**
     * Get the value property: A response message containing a list of secrets in the key vault along with a link to the
     * next page of secrets.
     * 
     * @return the value value.
     */
    public List<SecretItem> getValue() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of secrets.
     * 
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretListResult.
     */
    public static SecretListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretListResult deserializedSecretListResult = new SecretListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SecretItem> value = reader.readArray(reader1 -> SecretItem.fromJson(reader1));
                    deserializedSecretListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSecretListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretListResult;
        });
    }
}
