// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/** The deleted secret item containing metadata about the deleted secret. */
@Fluent
public final class DeletedSecretItem extends SecretItem {
    /*
     * The url of the recovery object, used to identify and recover the deleted secret.
     */
    private String recoveryId;

    /*
     * The time when the secret is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the secret was deleted, in UTC
     */
    private Long deletedDate;

    /** Creates an instance of DeletedSecretItem class. */
    public DeletedSecretItem() {
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted secret.
     *
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted secret.
     *
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedSecretItem object itself.
     */
    public DeletedSecretItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the secret is scheduled to be purged, in UTC.
     *
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the secret was deleted, in UTC.
     *
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretItem setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretItem setAttributes(SecretAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretItem setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", getContentType());
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedSecretItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedSecretItem if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedSecretItem.
     */
    public static DeletedSecretItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedSecretItem deserializedDeletedSecretItem = new DeletedSecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedSecretItem.setId(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretItem.setAttributes(SecretAttributes.fromJson(reader));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedSecretItem.setTags(tags);
                } else if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretItem.setContentType(reader.getString());
                } else if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretItem.setManaged(reader.getNullable(JsonReader::getBoolean));
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretItem.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedSecretItem;
        });
    }
}
