/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.PageRetriever;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretRestoreParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretSetParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SecretClientBuilder.class, isAsync=true, serviceInterfaces={SecretClientImpl.SecretClientService.class})
public final class SecretAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SecretAsyncClient.class);
    static final RequestOptions EMPTY_OPTIONS = new RequestOptions();
    private final SecretClientImpl implClient;
    private final String vaultUrl;

    SecretAsyncClient(SecretClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> setSecret(KeyVaultSecret secret) {
        try {
            return this.implClient.setSecretWithResponseAsync(secret.getName(), BinaryData.fromObject((Object)SecretClient.prepareSecretSetParameters(secret)), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapSetSecretException).map(response -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> setSecret(String name, String value) {
        try {
            return this.implClient.setSecretWithResponseAsync(name, BinaryData.fromObject((Object)new SecretSetParameters(value)), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapSetSecretException).map(response -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> setSecretWithResponse(KeyVaultSecret secret) {
        try {
            return this.implClient.setSecretWithResponseAsync(secret.getName(), BinaryData.fromObject((Object)SecretClient.prepareSecretSetParameters(secret)), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapSetSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapSetSecretException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> getSecret(String name) {
        return this.getSecret(name, "");
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> getSecret(String name, String version) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        try {
            return this.implClient.getSecretWithResponseAsync(name, version, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapGetSecretException).map(response -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> getSecretWithResponse(String name, String version) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        try {
            return this.implClient.getSecretWithResponseAsync(name, version, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapGetSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapGetSecretException(HttpResponseException e) {
        if (e.getResponse().getStatusCode() == 403) {
            return new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue());
        }
        return e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretProperties> updateSecretProperties(SecretProperties secretProperties) {
        try {
            return this.implClient.updateSecretWithResponseAsync(secretProperties.getName(), secretProperties.getVersion(), BinaryData.fromObject((Object)SecretClient.prepareUpdateSecretParameters(secretProperties)), EMPTY_OPTIONS).map(response -> SecretsModelsUtils.createSecretProperties((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretProperties>> updateSecretPropertiesWithResponse(SecretProperties secretProperties) {
        try {
            return this.implClient.updateSecretWithResponseAsync(secretProperties.getName(), secretProperties.getVersion(), BinaryData.fromObject((Object)SecretClient.prepareUpdateSecretParameters(secretProperties)), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createSecretProperties((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedSecret, Void> beginDeleteSecret(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedSecret>, Mono<DeletedSecret>> deleteActivationOperation(String name) {
        return pollingContext -> {
            try {
                return this.implClient.deleteSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)response.getValue()).toObject(DeletedSecretBundle.class)));
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<DeletedSecret>, Mono<PollResponse<DeletedSecret>>> deletePollOperation(String name) {
        return pollingContext -> this.implClient.getDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)response.getValue()).toObject(DeletedSecretBundle.class)))).onErrorResume(HttpResponseException.class, exception -> {
            if (exception.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecret> getDeletedSecret(String name) {
        try {
            return this.implClient.getDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)response.getValue()).toObject(DeletedSecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecret>> getDeletedSecretWithResponse(String name) {
        try {
            return this.implClient.getDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)response.getValue()).toObject(DeletedSecretBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecret(String name) {
        try {
            return this.implClient.purgeDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS).flatMap(response -> Mono.empty());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponse(String name) {
        try {
            return this.implClient.purgeDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> {
            try {
                return this.implClient.recoverDeletedSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<PollResponse<KeyVaultSecret>>> recoverPollOperation(String name) {
        return pollingContext -> this.implClient.getSecretWithResponseAsync(name, "", EMPTY_OPTIONS).map(response -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)))).onErrorResume(HttpResponseException.class, exception -> {
            if (exception.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupSecret(String name) {
        try {
            return this.implClient.backupSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> (BackupSecretResult)((BinaryData)response.getValue()).toObject(BackupSecretResult.class)).mapNotNull(BackupSecretResult::getValue);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupSecretWithResponse(String name) {
        try {
            return this.implClient.backupSecretWithResponseAsync(name, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toBytes()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> restoreSecretBackup(byte[] backup) {
        try {
            return this.implClient.restoreSecretWithResponseAsync(BinaryData.fromObject((Object)new SecretRestoreParameters(backup)), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapRestoreSecretException).map(response -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> restoreSecretBackupWithResponse(byte[] backup) {
        try {
            return this.implClient.restoreSecretWithResponseAsync(BinaryData.fromObject((Object)new SecretRestoreParameters(backup)), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, SecretAsyncClient::mapRestoreSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapRestoreSecretException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretProperties> listPropertiesOfSecrets() {
        try {
            return SecretAsyncClient.mapPages(this.implClient.getSecretsAsync(EMPTY_OPTIONS), binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedSecret> listDeletedSecrets() {
        try {
            return SecretAsyncClient.mapPages(this.implClient.getDeletedSecretsAsync(EMPTY_OPTIONS), binaryData -> SecretsModelsUtils.createDeletedSecret((DeletedSecretItem)binaryData.toObject(DeletedSecretItem.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name) {
        try {
            return SecretAsyncClient.mapPages(this.implClient.getSecretVersionsAsync(name, EMPTY_OPTIONS), binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private static <R, T> PagedFlux<R> mapPages(PagedFlux<T> pagedFlux, Function<T, R> mapper) {
        Function<PagedResponse, PagedResponse> responseMapper = inputResponse -> new PagedResponseBase(inputResponse.getRequest(), inputResponse.getStatusCode(), inputResponse.getHeaders(), inputResponse.getValue().stream().map(mapper).collect(Collectors.toList()), (String)inputResponse.getContinuationToken(), null);
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
            return flux.map(responseMapper);
        };
        return PagedFlux.create(provider);
    }
}

