// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The key verify result.
 */
@Immutable
public final class KeyVerifyResult implements JsonSerializable<KeyVerifyResult> {
    /*
     * True if the signature is verified, otherwise false.
     */
    private Boolean value;

    /**
     * Creates an instance of KeyVerifyResult class.
     */
    public KeyVerifyResult() {
    }

    /**
     * Get the value property: True if the signature is verified, otherwise false.
     * 
     * @return the value value.
     */
    public Boolean isValue() {
        return this.value;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVerifyResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVerifyResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVerifyResult.
     */
    public static KeyVerifyResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVerifyResult deserializedKeyVerifyResult = new KeyVerifyResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedKeyVerifyResult.value = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVerifyResult;
        });
    }
}
