// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** The key restore parameters. */
@Fluent
public final class KeyRestoreParameters implements JsonSerializable<KeyRestoreParameters> {
    /*
     * The backup blob associated with a key bundle.
     */
    private Base64Url keyBundleBackup;

    /** Creates an instance of KeyRestoreParameters class. */
    public KeyRestoreParameters() {
    }

    /**
     * Get the keyBundleBackup property: The backup blob associated with a key bundle.
     *
     * @return the keyBundleBackup value.
     */
    public byte[] getKeyBundleBackup() {
        if (this.keyBundleBackup == null) {
            return null;
        }
        return this.keyBundleBackup.decodedBytes();
    }

    /**
     * Set the keyBundleBackup property: The backup blob associated with a key bundle.
     *
     * @param keyBundleBackup the keyBundleBackup value to set.
     * @return the KeyRestoreParameters object itself.
     */
    public KeyRestoreParameters setKeyBundleBackup(byte[] keyBundleBackup) {
        if (keyBundleBackup == null) {
            this.keyBundleBackup = null;
        } else {
            this.keyBundleBackup = Base64Url.encode(CoreUtils.clone(keyBundleBackup));
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.keyBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyRestoreParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyRestoreParameters if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyRestoreParameters.
     */
    public static KeyRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyRestoreParameters deserializedKeyRestoreParameters = new KeyRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedKeyRestoreParameters.keyBundleBackup
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyRestoreParameters;
        });
    }
}
