// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import java.io.IOException;
import java.util.Objects;

/** The release key parameters. */
@Fluent
public final class KeyReleaseParameters implements JsonSerializable<KeyReleaseParameters> {
    /*
     * The attestation assertion for the target of the key release.
     */
    private String targetAttestationToken;

    /*
     * A client provided nonce for freshness.
     */
    private String nonce;

    /*
     * The encryption algorithm to use to protected the exported key material
     */
    private KeyExportEncryptionAlgorithm enc;

    /** Creates an instance of KeyReleaseParameters class. */
    public KeyReleaseParameters() {
    }

    /**
     * Get the targetAttestationToken property: The attestation assertion for the target of the key release.
     *
     * @return the targetAttestationToken value.
     */
    public String getTargetAttestationToken() {
        return this.targetAttestationToken;
    }

    /**
     * Set the targetAttestationToken property: The attestation assertion for the target of the key release.
     *
     * @param targetAttestationToken the targetAttestationToken value to set.
     * @return the KeyReleaseParameters object itself.
     */
    public KeyReleaseParameters setTargetAttestationToken(String targetAttestationToken) {
        this.targetAttestationToken = targetAttestationToken;
        return this;
    }

    /**
     * Get the nonce property: A client provided nonce for freshness.
     *
     * @return the nonce value.
     */
    public String getNonce() {
        return this.nonce;
    }

    /**
     * Set the nonce property: A client provided nonce for freshness.
     *
     * @param nonce the nonce value to set.
     * @return the KeyReleaseParameters object itself.
     */
    public KeyReleaseParameters setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    /**
     * Get the enc property: The encryption algorithm to use to protected the exported key material.
     *
     * @return the enc value.
     */
    public KeyExportEncryptionAlgorithm getEnc() {
        return this.enc;
    }

    /**
     * Set the enc property: The encryption algorithm to use to protected the exported key material.
     *
     * @param enc the enc value to set.
     * @return the KeyReleaseParameters object itself.
     */
    public KeyReleaseParameters setEnc(KeyExportEncryptionAlgorithm enc) {
        this.enc = enc;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.targetAttestationToken);
        jsonWriter.writeStringField("nonce", this.nonce);
        jsonWriter.writeStringField("enc", Objects.toString(this.enc, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyReleaseParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyReleaseParameters if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyReleaseParameters.
     */
    public static KeyReleaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyReleaseParameters deserializedKeyReleaseParameters = new KeyReleaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("target".equals(fieldName)) {
                    deserializedKeyReleaseParameters.targetAttestationToken = reader.getString();
                } else if ("nonce".equals(fieldName)) {
                    deserializedKeyReleaseParameters.nonce = reader.getString();
                } else if ("enc".equals(fieldName)) {
                    deserializedKeyReleaseParameters.enc = KeyExportEncryptionAlgorithm.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyReleaseParameters;
        });
    }
}
