// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The key operation result. */
@Immutable
public final class KeyOperationResult implements JsonSerializable<KeyOperationResult> {
    /*
     * Key identifier
     */
    private String kid;

    /*
     * The value property.
     */
    private Base64Url result;

    /*
     * The iv property.
     */
    private Base64Url iv;

    /*
     * The tag property.
     */
    private Base64Url authenticationTag;

    /*
     * The aad property.
     */
    private Base64Url additionalAuthenticatedData;

    /** Creates an instance of KeyOperationResult class. */
    public KeyOperationResult() {
    }

    /**
     * Get the kid property: Key identifier.
     *
     * @return the kid value.
     */
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the result property: The value property.
     *
     * @return the result value.
     */
    public byte[] getResult() {
        if (this.result == null) {
            return null;
        }
        return this.result.decodedBytes();
    }

    /**
     * Get the iv property: The iv property.
     *
     * @return the iv value.
     */
    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    /**
     * Get the authenticationTag property: The tag property.
     *
     * @return the authenticationTag value.
     */
    public byte[] getAuthenticationTag() {
        if (this.authenticationTag == null) {
            return null;
        }
        return this.authenticationTag.decodedBytes();
    }

    /**
     * Get the additionalAuthenticatedData property: The aad property.
     *
     * @return the additionalAuthenticatedData value.
     */
    public byte[] getAdditionalAuthenticatedData() {
        if (this.additionalAuthenticatedData == null) {
            return null;
        }
        return this.additionalAuthenticatedData.decodedBytes();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyOperationResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyOperationResult if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyOperationResult.
     */
    public static KeyOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyOperationResult deserializedKeyOperationResult = new KeyOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kid".equals(fieldName)) {
                    deserializedKeyOperationResult.kid = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedKeyOperationResult.result
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("iv".equals(fieldName)) {
                    deserializedKeyOperationResult.iv
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("tag".equals(fieldName)) {
                    deserializedKeyOperationResult.authenticationTag
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("aad".equals(fieldName)) {
                    deserializedKeyOperationResult.additionalAuthenticatedData
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyOperationResult;
        });
    }
}
