// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyListResult;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyCreateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyImportParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyListResult;
import com.azure.security.keyvault.keys.implementation.models.KeyOperationResult;
import com.azure.security.keyvault.keys.implementation.models.KeyOperationsParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyReleaseParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.implementation.models.KeyRestoreParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.implementation.models.KeySignParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyUpdateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.keys.implementation.models.KeyVerifyParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVerifyResult;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the KeyClient type. */
public final class KeyClientImpl {
    /** The proxy service used to perform REST calls. */
    private final KeyClientService service;

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of KeyClient client.
     *
     * @param apiVersion Api Version.
     */
    public KeyClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of KeyClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param apiVersion Api Version.
     */
    public KeyClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of KeyClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param apiVersion Api Version.
     */
    public KeyClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = RestProxy.create(KeyClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /** The interface defining all the services for KeyClient to be used by the proxy service to perform REST calls. */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "KeyClient")
    public interface KeyClientService {
        @Post("/keys/{key-name}/create")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> createKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyCreateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/create")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> createKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyCreateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/rotate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> rotateKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/rotate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> rotateKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> importKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyImportParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> importKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyImportParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Delete("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedKeyBundle>> deleteKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/keys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedKeyBundle> deleteKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> updateKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeyUpdateParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> updateKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeyUpdateParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> getKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/{key-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> getKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyListResult>> getKeyVersions(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyListResult> getKeyVersionsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyListResult>> getKeys(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyListResult> getKeysSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<BackupKeyResult>> backupKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<BackupKeyResult> backupKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> restoreKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyRestoreParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> restoreKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyRestoreParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyOperationResult>> encrypt(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyOperationResult> encryptSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyOperationResult>> decrypt(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyOperationResult> decryptSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyOperationResult>> sign(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeySignParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyOperationResult> signSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeySignParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyVerifyResult>> verify(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeyVerifyParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyVerifyResult> verifySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") KeyVerifyParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyOperationResult>> wrapKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyOperationResult> wrapKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyOperationResult>> unwrapKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyOperationResult> unwrapKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyOperationsParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/release")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<ReleaseKeyResult>> release(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyReleaseParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/keys/{key-name}/{key-version}/release")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<ReleaseKeyResult> releaseSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @PathParam("key-version") String keyVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyReleaseParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/deletedkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedKeyListResult>> getDeletedKeys(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedkeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedKeyListResult> getDeletedKeysSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedkeys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedKeyBundle>> getDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedkeys/{key-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedKeyBundle> getDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/deletedkeys/{key-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Void>> purgeDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/deletedkeys/{key-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Void> purgeDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/deletedkeys/{key-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyBundle>> recoverDeletedKey(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/deletedkeys/{key-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyBundle> recoverDeletedKeySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyRotationPolicy>> getKeyRotationPolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyRotationPolicy> getKeyRotationPolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyRotationPolicy keyRotationPolicy, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/keys/{key-name}/rotationpolicy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyRotationPolicy> updateKeyRotationPolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("key-name") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyRotationPolicy keyRotationPolicy, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/rng")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<RandomBytes>> getRandomBytes(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GetRandomBytesRequest parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/rng")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<RandomBytes> getRandomBytesSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GetRandomBytesRequest parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyListResult>> getKeyVersionsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyListResult> getKeyVersionsNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<KeyListResult>> getKeysNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<KeyListResult> getKeysNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedKeyListResult>> getDeletedKeysNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedKeyListResult> getDeletedKeysNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> createKeyWithResponseAsync(String vaultBaseUrl, String keyName, KeyType kty,
        Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes,
        Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        final String accept = "application/json";
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.setKty(kty);
        parameters.setKeySize(keySize);
        parameters.setPublicExponent(publicExponent);
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setCrv(crv);
        parameters.setReleasePolicy(releasePolicy);
        return FluxUtil.withContext(
            context -> service.createKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> createKeyWithResponseAsync(String vaultBaseUrl, String keyName, KeyType kty,
        Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes,
        Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        final String accept = "application/json";
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.setKty(kty);
        parameters.setKeySize(keySize);
        parameters.setPublicExponent(publicExponent);
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setCrv(crv);
        parameters.setReleasePolicy(releasePolicy);
        return service.createKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize,
        Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        return createKeyWithResponseAsync(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes,
            tags, crv, releasePolicy).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize,
        Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        return createKeyWithResponseAsync(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes,
            tags, crv, releasePolicy, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> createKeyWithResponse(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize,
        Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        final String accept = "application/json";
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.setKty(kty);
        parameters.setKeySize(keySize);
        parameters.setPublicExponent(publicExponent);
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setCrv(crv);
        parameters.setReleasePolicy(releasePolicy);
        return service.createKeySync(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     *
     * <p>The create key operation can be used to create any key type in Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key. The value you
     *     provide may be copied globally for the purpose of running the service. The value provided should not include
     *     personally identifiable or sensitive information.
     * @param kty JsonWebKey Key Type (kty), as defined in
     *     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param publicExponent The public exponent for a RSA key.
     * @param keyOps Array of KeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param crv Elliptic curve name.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle createKey(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize,
        Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        return createKeyWithResponse(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes, tags,
            crv, releasePolicy, Context.NONE).getValue();
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> rotateKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.rotateKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> rotateKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.rotateKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> rotateKeyAsync(String vaultBaseUrl, String keyName) {
        return rotateKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> rotateKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return rotateKeyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> rotateKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.rotateKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
     *
     * <p>The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to be rotated. The system will generate a new version in the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle rotateKey(String vaultBaseUrl, String keyName) {
        return rotateKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> importKeyWithResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key,
        Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        final String accept = "application/json";
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.setHsm(hsm);
        parameters.setKey(key);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return FluxUtil.withContext(
            context -> service.importKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> importKeyWithResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key,
        Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy,
        Context context) {
        final String accept = "application/json";
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.setHsm(hsm);
        parameters.setKey(key);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return service.importKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm,
        KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return importKeyWithResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm,
        KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        return importKeyWithResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> importKeyWithResponse(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm,
        KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        final String accept = "application/json";
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.setHsm(hsm);
        parameters.setKey(key);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return service.importKeySync(vaultBaseUrl, keyName, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     *
     * <p>The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
     * exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param key The Json web key.
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm,
        KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return importKeyWithResponse(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> deleteKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> deleteKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.deleteKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName) {
        return deleteKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return deleteKeyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedKeyBundle> deleteKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.deleteKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     *
     * <p>The delete key operation cannot be used to remove individual versions of a key. This operation removes the
     * cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or
     * Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedKeyBundle deleteKey(String vaultBaseUrl, String keyName) {
        return deleteKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> updateKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion,
        List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyReleasePolicy releasePolicy) {
        final String accept = "application/json";
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return FluxUtil.withContext(context -> service.updateKey(vaultBaseUrl, keyName, keyVersion,
            this.getApiVersion(), parameters, accept, context));
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> updateKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion,
        List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyReleasePolicy releasePolicy, Context context) {
        final String accept = "application/json";
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return service.updateKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyReleasePolicy releasePolicy) {
        return updateKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyReleasePolicy releasePolicy, Context context) {
        return updateKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy,
            context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> updateKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags,
        KeyReleasePolicy releasePolicy, Context context) {
        final String accept = "application/json";
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return service.updateKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key
     * version stored in Azure Key Vault.
     *
     * <p>In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic
     * material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes The attributes of a key managed by the key vault service.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param releasePolicy The policy rules under which the key can be exported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps,
        KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return updateKeyWithResponse(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy,
            Context.NONE).getValue();
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> getKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), accept, context));
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> getKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion,
        Context context) {
        final String accept = "application/json";
        return service.getKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return getKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, Context context) {
        return getKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> getKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        Context context) {
        final String accept = "application/json";
        return service.getKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the public part of a stored key.
     *
     * <p>The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
     * is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key. This URI fragment is
     *     optional. If not specified, the latest version of the key is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion) {
        return getKeyWithResponse(vaultBaseUrl, keyName, keyVersion, Context.NONE).getValue();
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName,
        Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getKeyVersions(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName,
        Integer maxresults, Context context) {
        final String accept = "application/json";
        return service.getKeyVersions(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return new PagedFlux<>(() -> getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults),
            nextLink -> getKeyVersionsNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults,
        Context context) {
        return new PagedFlux<>(() -> getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults, context),
            nextLink -> getKeyVersionsNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsSinglePage(String vaultBaseUrl, String keyName, Integer maxresults) {
        final String accept = "application/json";
        Response<KeyListResult> res
            = service.getKeyVersionsSync(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsSinglePage(String vaultBaseUrl, String keyName, Integer maxresults,
        Context context) {
        final String accept = "application/json";
        Response<KeyListResult> res
            = service.getKeyVersionsSync(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) {
        return new PagedIterable<>(() -> getKeyVersionsSinglePage(vaultBaseUrl, keyName, maxresults, Context.NONE),
            nextLink -> getKeyVersionsNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * Retrieves a list of individual key versions with the same key name.
     *
     * <p>The full key identifier, attributes, and tags are provided in the response. This operation requires the
     * keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults,
        Context context) {
        return new PagedIterable<>(() -> getKeyVersionsSinglePage(vaultBaseUrl, keyName, maxresults, context),
            nextLink -> getKeyVersionsNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getKeys(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults,
        Context context) {
        final String accept = "application/json";
        return service.getKeys(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<>(() -> getKeysSinglePageAsync(vaultBaseUrl, maxresults),
            nextLink -> getKeysNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeysAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<>(() -> getKeysSinglePageAsync(vaultBaseUrl, maxresults, context),
            nextLink -> getKeysNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysSinglePage(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        Response<KeyListResult> res
            = service.getKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        final String accept = "application/json";
        Response<KeyListResult> res
            = service.getKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<>(() -> getKeysSinglePage(vaultBaseUrl, maxresults, Context.NONE),
            nextLink -> getKeysNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes,
     * and tags are provided in the response. Individual versions of a key are not listed in the response. This
     * operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<>(() -> getKeysSinglePage(vaultBaseUrl, maxresults, context),
            nextLink -> getKeysNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupKeyResult>> backupKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.backupKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupKeyResult>> backupKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.backupKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName) {
        return backupKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return backupKeyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupKeyResult> backupKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.backupKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     *
     * <p>The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
     * NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material
     * is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to
     * allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into
     * another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type
     * from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within
     * geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another
     * geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical
     * area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup key result, containing the backup blob.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupKeyResult backupKey(String vaultBaseUrl, String keyName) {
        return backupKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> restoreKeyWithResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        final String accept = "application/json";
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.setKeyBundleBackup(keyBundleBackup);
        return FluxUtil.withContext(
            context -> service.restoreKey(vaultBaseUrl, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> restoreKeyWithResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup,
        Context context) {
        final String accept = "application/json";
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.setKeyBundleBackup(keyBundleBackup);
        return service.restoreKey(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        return restoreKeyWithResponseAsync(vaultBaseUrl, keyBundleBackup)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, Context context) {
        return restoreKeyWithResponseAsync(vaultBaseUrl, keyBundleBackup, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> restoreKeyWithResponse(String vaultBaseUrl, byte[] keyBundleBackup, Context context) {
        final String accept = "application/json";
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.setKeyBundleBackup(keyBundleBackup);
        return service.restoreKeySync(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up key to a vault.
     *
     * <p>Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and
     * access control policies. The RESTORE operation may be used to import a previously backed up key. Individual
     * versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when
     * it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be
     * rejected. While the key name is retained during restore, the final key identifier will change if the key is
     * restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE
     * operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure
     * Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This
     * operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup) {
        return restoreKeyWithResponse(vaultBaseUrl, keyBundleBackup, Context.NONE).getValue();
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> encryptWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return FluxUtil.withContext(context -> service.encrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> encryptWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag,
        Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.encrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return encryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return encryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyOperationResult> encryptWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.encryptSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     *
     * <p>The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
     * Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent
     * on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for
     * symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public
     * portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a
     * key-reference but do not have access to the public key material. This operation requires the keys/encrypt
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyOperationResult encrypt(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return encryptWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE)
            .getValue();
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> decryptWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return FluxUtil.withContext(context -> service.decrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> decryptWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag,
        Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.decrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return decryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return decryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyOperationResult> decryptWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.decryptSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Decrypts a single block of encrypted data.
     *
     * <p>The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
     * algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted,
     * the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies
     * to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This
     * operation requires the keys/decrypt permission. Microsoft recommends not to use CBC algorithms for decryption
     * without first ensuring the integrity of the ciphertext using an HMAC, for example. See
     * https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyOperationResult decrypt(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return decryptWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE)
            .getValue();
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> signWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        final String accept = "application/json";
        KeySignParameters parameters = new KeySignParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        return FluxUtil.withContext(context -> service.sign(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> signWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        final String accept = "application/json";
        KeySignParameters parameters = new KeySignParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        return service.sign(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return signWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        return signWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyOperationResult> signWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        final String accept = "application/json";
        KeySignParameters parameters = new KeySignParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        return service.signSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates a signature from a digest using the specified key.
     *
     * <p>The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this
     * operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types,
     *     see JsonWebKeySignatureAlgorithm.
     * @param value The value parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyOperationResult sign(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return signWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, Context.NONE).getValue();
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyVerifyResult>> verifyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        final String accept = "application/json";
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setDigest(digest);
        parameters.setSignature(signature);
        return FluxUtil.withContext(context -> service.verify(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyVerifyResult>> verifyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        final String accept = "application/json";
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setDigest(digest);
        parameters.setSignature(signature);
        return service.verify(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return verifyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        return verifyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyVerifyResult> verifyWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        final String accept = "application/json";
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setDigest(digest);
        parameters.setSignature(signature);
        return service.verifySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Verifies a signature using a specified key.
     *
     * <p>The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly
     * necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the
     * public portion of the key but this operation is supported as a convenience for callers that only have a
     * key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see
     *     JsonWebKeySignatureAlgorithm.
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key verify result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyVerifyResult verify(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return verifyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature, Context.NONE)
            .getValue();
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> wrapKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return FluxUtil.withContext(context -> service.wrapKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> wrapKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag,
        Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.wrapKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return wrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return wrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyOperationResult> wrapKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.wrapKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Wraps a symmetric key using a specified key.
     *
     * <p>The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
     * stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure
     * Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This
     * operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have
     * access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyOperationResult wrapKey(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return wrapKeyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE)
            .getValue();
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> unwrapKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return FluxUtil.withContext(context -> service.unwrapKey(vaultBaseUrl, keyName, keyVersion,
            this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> unwrapKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag,
        Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.unwrapKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return unwrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return unwrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyOperationResult> unwrapKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        final String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return service.unwrapKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     *
     * <p>The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This
     * operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys
     * stored in Azure Key Vault since it uses the private portion of the key. This operation requires the
     * keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier.
     * @param value The value parameter.
     * @param iv Cryptographically random, non-repeating initialization vector for symmetric algorithms.
     * @param aad Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
     * @param tag The tag to authenticate when performing decryption with an authenticated algorithm.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyOperationResult unwrapKey(String vaultBaseUrl, String keyName, String keyVersion,
        JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return unwrapKeyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE)
            .getValue();
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        final String accept = "application/json";
        KeyReleaseParameters parameters = new KeyReleaseParameters();
        parameters.setTargetAttestationToken(targetAttestationToken);
        parameters.setNonce(nonce);
        parameters.setEnc(enc);
        return FluxUtil.withContext(context -> service.release(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(),
            parameters, accept, context));
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseWithResponseAsync(String vaultBaseUrl, String keyName,
        String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc,
        Context context) {
        final String accept = "application/json";
        KeyReleaseParameters parameters = new KeyReleaseParameters();
        parameters.setTargetAttestationToken(targetAttestationToken);
        parameters.setNonce(nonce);
        parameters.setEnc(enc);
        return service.release(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseAsync(String vaultBaseUrl, String keyName, String keyVersion,
        String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        return releaseWithResponseAsync(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseAsync(String vaultBaseUrl, String keyName, String keyVersion,
        String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc, Context context) {
        return releaseWithResponseAsync(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ReleaseKeyResult> releaseWithResponse(String vaultBaseUrl, String keyName, String keyVersion,
        String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc, Context context) {
        final String accept = "application/json";
        KeyReleaseParameters parameters = new KeyReleaseParameters();
        parameters.setTargetAttestationToken(targetAttestationToken);
        parameters.setNonce(nonce);
        parameters.setEnc(enc);
        return service.releaseSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Releases a key.
     *
     * <p>The release key operation is applicable to all key types. The target key must be marked exportable. This
     * operation requires the keys/release permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param targetAttestationToken The attestation assertion for the target of the key release.
     * @param nonce A client provided nonce for freshness.
     * @param enc The encryption algorithm to use to protected the exported key material.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the release result, containing the released key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ReleaseKeyResult release(String vaultBaseUrl, String keyName, String keyVersion,
        String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        return releaseWithResponse(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc, Context.NONE)
            .getValue();
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getDeletedKeys(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults,
        Context context) {
        final String accept = "application/json";
        return service.getDeletedKeys(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedKeyItem> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<>(() -> getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults),
            nextLink -> getDeletedKeysNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedKeyItem> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<>(() -> getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults, context),
            nextLink -> getDeletedKeysNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysSinglePage(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        Response<DeletedKeyListResult> res
            = service.getDeletedKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysSinglePage(String vaultBaseUrl, Integer maxresults,
        Context context) {
        final String accept = "application/json";
        Response<DeletedKeyListResult> res
            = service.getDeletedKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<>(() -> getDeletedKeysSinglePage(vaultBaseUrl, maxresults, Context.NONE),
            nextLink -> getDeletedKeysNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * Lists the deleted keys in the specified vault.
     *
     * <p>Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a
     * deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable
     * for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if
     * invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<>(() -> getDeletedKeysSinglePage(vaultBaseUrl, maxresults, context),
            nextLink -> getDeletedKeysNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> getDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> getDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.getDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return getDeletedKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return getDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedKeyBundle> getDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.getDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the public part of a deleted key.
     *
     * <p>The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked
     * on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the
     * keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedKeyBundle getDeletedKey(String vaultBaseUrl, String keyName) {
        return getDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.purgeDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.purgeDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return purgeDeletedKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return purgeDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.purgeDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Permanently deletes the specified key.
     *
     * <p>The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
     * invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation
     * requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeDeletedKey(String vaultBaseUrl, String keyName) {
        purgeDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE);
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> recoverDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.recoverDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> recoverDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.recoverDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return recoverDeletedKeyWithResponseAsync(vaultBaseUrl, keyName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return recoverDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyBundle> recoverDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        final String accept = "application/json";
        return service.recoverDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Recovers the deleted key to its latest version.
     *
     * <p>The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers
     * the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an
     * error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires
     * the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a KeyBundle consisting of a WebKey plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyBundle recoverDeletedKey(String vaultBaseUrl, String keyName) {
        return recoverDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponseAsync(String vaultBaseUrl,
        String keyName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getKeyRotationPolicy(vaultBaseUrl, keyName, this.getApiVersion(), accept, context));
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponseAsync(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.getKeyRotationPolicy(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicyAsync(String vaultBaseUrl, String keyName) {
        return getKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicyAsync(String vaultBaseUrl, String keyName, Context context) {
        return getKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String vaultBaseUrl, String keyName,
        Context context) {
        final String accept = "application/json";
        return service.getKeyRotationPolicySync(vaultBaseUrl, keyName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the policy for a key.
     *
     * <p>The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This
     * operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyRotationPolicy getKeyRotationPolicy(String vaultBaseUrl, String keyName) {
        return getKeyRotationPolicyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponseAsync(String vaultBaseUrl,
        String keyName, KeyRotationPolicy keyRotationPolicy) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.updateKeyRotationPolicy(vaultBaseUrl, keyName,
            this.getApiVersion(), keyRotationPolicy, accept, context));
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponseAsync(String vaultBaseUrl,
        String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        final String accept = "application/json";
        return service.updateKeyRotationPolicy(vaultBaseUrl, keyName, this.getApiVersion(), keyRotationPolicy, accept,
            context);
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicyAsync(String vaultBaseUrl, String keyName,
        KeyRotationPolicy keyRotationPolicy) {
        return updateKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, keyRotationPolicy)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicyAsync(String vaultBaseUrl, String keyName,
        KeyRotationPolicy keyRotationPolicy, Context context) {
        return updateKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, keyRotationPolicy, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String vaultBaseUrl, String keyName,
        KeyRotationPolicy keyRotationPolicy, Context context) {
        final String accept = "application/json";
        return service.updateKeyRotationPolicySync(vaultBaseUrl, keyName, this.getApiVersion(), keyRotationPolicy,
            accept, context);
    }

    /**
     * Updates the rotation policy for a key.
     *
     * <p>Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key in the given vault.
     * @param keyRotationPolicy The policy for the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyRotationPolicy updateKeyRotationPolicy(String vaultBaseUrl, String keyName,
        KeyRotationPolicy keyRotationPolicy) {
        return updateKeyRotationPolicyWithResponse(vaultBaseUrl, keyName, keyRotationPolicy, Context.NONE).getValue();
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RandomBytes>> getRandomBytesWithResponseAsync(String vaultBaseUrl, int count) {
        final String accept = "application/json";
        GetRandomBytesRequest parameters = new GetRandomBytesRequest();
        parameters.setCount(count);
        return FluxUtil.withContext(
            context -> service.getRandomBytes(vaultBaseUrl, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RandomBytes>> getRandomBytesWithResponseAsync(String vaultBaseUrl, int count,
        Context context) {
        final String accept = "application/json";
        GetRandomBytesRequest parameters = new GetRandomBytesRequest();
        parameters.setCount(count);
        return service.getRandomBytes(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RandomBytes> getRandomBytesAsync(String vaultBaseUrl, int count) {
        return getRandomBytesWithResponseAsync(vaultBaseUrl, count).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RandomBytes> getRandomBytesAsync(String vaultBaseUrl, int count, Context context) {
        return getRandomBytesWithResponseAsync(vaultBaseUrl, count, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RandomBytes> getRandomBytesWithResponse(String vaultBaseUrl, int count, Context context) {
        final String accept = "application/json";
        GetRandomBytesRequest parameters = new GetRandomBytesRequest();
        parameters.setCount(count);
        return service.getRandomBytesSync(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Get the requested number of bytes containing random values.
     *
     * <p>Get the requested number of bytes containing random values from a managed HSM.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param count The requested number of random bytes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the requested number of bytes containing random values from a managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RandomBytes getRandomBytes(String vaultBaseUrl, int count) {
        return getRandomBytesWithResponse(vaultBaseUrl, count, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getKeyVersionsNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        return service.getKeyVersionsNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<KeyListResult> res = service.getKeyVersionsNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<KeyListResult> res = service.getKeyVersionsNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getKeysNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        return service.getKeysNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<KeyListResult> res = service.getKeysNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<KeyListResult> res = service.getKeysNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getDeletedKeysNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        return service.getDeletedKeysNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<DeletedKeyListResult> res
            = service.getDeletedKeysNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysNextSinglePage(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        Response<DeletedKeyListResult> res = service.getDeletedKeysNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }
}
