/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.SecretMinClientImpl;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CryptographyClientBuilder.class, isAsync=true, serviceInterfaces={KeyClientImpl.KeyClientService.class, SecretMinClientImpl.SecretMinClientService.class})
public class CryptographyAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyAsyncClient.class);
    private final HttpPipeline pipeline;
    private volatile boolean skipLocalClientCreation;
    private volatile LocalKeyCryptographyClient localKeyCryptographyClient;
    final CryptographyClientImpl implClient;
    final String keyId;

    CryptographyAsyncClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version, boolean disableKeyCaching) {
        this.implClient = new CryptographyClientImpl(keyId, pipeline, version);
        this.keyId = keyId;
        this.pipeline = pipeline;
        this.skipLocalClientCreation = disableKeyCaching;
    }

    CryptographyAsyncClient(JsonWebKey jsonWebKey) {
        Objects.requireNonNull(jsonWebKey, "The JSON Web Key is required.");
        if (!jsonWebKey.isValid()) {
            throw new IllegalArgumentException("The JSON Web Key is not valid.");
        }
        if (jsonWebKey.getKeyOps() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key operations property is not configured.");
        }
        if (jsonWebKey.getKeyType() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key type property is not configured.");
        }
        this.implClient = null;
        this.keyId = jsonWebKey.getId();
        this.pipeline = null;
        try {
            this.localKeyCryptographyClient = CryptographyUtils.createLocalClient(jsonWebKey, null);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not initialize local cryptography client.", e));
        }
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey() {
        return this.getKeyWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse() {
        if (this.implClient != null) {
            try {
                return this.implClient.getKeyAsync();
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        }
        return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new UnsupportedOperationException("Operation not supported when operating in local-only mode."));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.encryptAsync(algorithm, plaintext, (Context)context);
                }
                return this.implClient.encryptAsync(algorithm, plaintext, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EncryptResult> encrypt(EncryptParameters encryptParameters) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.encryptAsync(encryptParameters, (Context)context);
                }
                return this.implClient.encryptAsync(encryptParameters, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.decryptAsync(algorithm, ciphertext, (Context)context);
                }
                return this.implClient.decryptAsync(algorithm, ciphertext, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DecryptResult> decrypt(DecryptParameters decryptParameters) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.decryptAsync(decryptParameters, (Context)context);
                }
                return this.implClient.decryptAsync(decryptParameters, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.signAsync(algorithm, digest, (Context)context);
                }
                return this.implClient.signAsync(algorithm, digest, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.verifyAsync(algorithm, digest, signature, (Context)context);
                }
                return this.implClient.verifyAsync(algorithm, digest, signature, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.wrapKeyAsync(algorithm, key, (Context)context);
                }
                return this.implClient.wrapKeyAsync(algorithm, key, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.unwrapKeyAsync(algorithm, encryptedKey, (Context)context);
                }
                return this.implClient.unwrapKeyAsync(algorithm, encryptedKey, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.signDataAsync(algorithm, data, (Context)context);
                }
                return this.implClient.signDataAsync(algorithm, data, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.isLocalClientAvailable().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.localKeyCryptographyClient.verifyDataAsync(algorithm, data, signature, (Context)context);
                }
                return this.implClient.verifyDataAsync(algorithm, data, signature, (Context)context);
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Boolean> isLocalClientAvailable() {
        if (!this.skipLocalClientCreation && this.localKeyCryptographyClient == null) {
            return CryptographyUtils.retrieveJwkAndCreateLocalAsyncClient(this.implClient).map(localClient -> {
                this.localKeyCryptographyClient = localClient;
                return true;
            }).onErrorResume(t -> {
                if (CryptographyUtils.isThrowableRetryable(t)) {
                    LOGGER.log(LogLevel.VERBOSE, () -> "Could not set up local cryptography for this operation. Defaulting to service-side cryptography.", t);
                } else {
                    this.skipLocalClientCreation = true;
                    LOGGER.log(LogLevel.VERBOSE, () -> "Could not set up local cryptography. Defaulting toservice-side cryptography for all operations.", t);
                }
                return Mono.just((Object)false);
            });
        }
        return Mono.just((Object)(this.localKeyCryptographyClient != null ? 1 : 0));
    }
}

