// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/** The key import parameters. */
@Fluent
public final class KeyImportParameters implements JsonSerializable<KeyImportParameters> {
    /*
     * Whether to import as a hardware key (HSM) or software key.
     */
    private Boolean hsm;

    /*
     * The Json web key
     */
    private JsonWebKey key;

    /*
     * The key management attributes.
     */
    private KeyAttributes keyAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /*
     * The policy rules under which the key can be exported.
     */
    private KeyReleasePolicy releasePolicy;

    /** Creates an instance of KeyImportParameters class. */
    public KeyImportParameters() {}

    /**
     * Get the hsm property: Whether to import as a hardware key (HSM) or software key.
     *
     * @return the hsm value.
     */
    public Boolean isHsm() {
        return this.hsm;
    }

    /**
     * Set the hsm property: Whether to import as a hardware key (HSM) or software key.
     *
     * @param hsm the hsm value to set.
     * @return the KeyImportParameters object itself.
     */
    public KeyImportParameters setHsm(Boolean hsm) {
        this.hsm = hsm;
        return this;
    }

    /**
     * Get the key property: The Json web key.
     *
     * @return the key value.
     */
    public JsonWebKey getKey() {
        return this.key;
    }

    /**
     * Set the key property: The Json web key.
     *
     * @param key the key value to set.
     * @return the KeyImportParameters object itself.
     */
    public KeyImportParameters setKey(JsonWebKey key) {
        this.key = key;
        return this;
    }

    /**
     * Get the keyAttributes property: The key management attributes.
     *
     * @return the keyAttributes value.
     */
    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    /**
     * Set the keyAttributes property: The key management attributes.
     *
     * @param keyAttributes the keyAttributes value to set.
     * @return the KeyImportParameters object itself.
     */
    public KeyImportParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @param tags the tags value to set.
     * @return the KeyImportParameters object itself.
     */
    public KeyImportParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the releasePolicy property: The policy rules under which the key can be exported.
     *
     * @return the releasePolicy value.
     */
    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    /**
     * Set the releasePolicy property: The policy rules under which the key can be exported.
     *
     * @param releasePolicy the releasePolicy value to set.
     * @return the KeyImportParameters object itself.
     */
    public KeyImportParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeBooleanField("Hsm", this.hsm);
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyImportParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyImportParameters if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyImportParameters.
     */
    public static KeyImportParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyImportParameters deserializedKeyImportParameters = new KeyImportParameters();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("key".equals(fieldName)) {
                            deserializedKeyImportParameters.key = JsonWebKey.fromJson(reader);
                        } else if ("Hsm".equals(fieldName)) {
                            deserializedKeyImportParameters.hsm = reader.getNullable(JsonReader::getBoolean);
                        } else if ("attributes".equals(fieldName)) {
                            deserializedKeyImportParameters.keyAttributes = KeyAttributes.fromJson(reader);
                        } else if ("tags".equals(fieldName)) {
                            Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                            deserializedKeyImportParameters.tags = tags;
                        } else if ("release_policy".equals(fieldName)) {
                            deserializedKeyImportParameters.releasePolicy = KeyReleasePolicy.fromJson(reader);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyImportParameters;
                });
    }
}
