/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class KeyRotationPolicyAttributes
implements JsonSerializable<KeyRotationPolicyAttributes> {
    private String expiryTime;
    private Long created;
    private Long updated;

    public String getExpiryTime() {
        return this.expiryTime;
    }

    public KeyRotationPolicyAttributes setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiryTime", this.expiryTime);
        return jsonWriter.writeEndObject();
    }

    public static KeyRotationPolicyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (KeyRotationPolicyAttributes)jsonReader.readObject(reader -> {
            KeyRotationPolicyAttributes deserializedKeyRotationPolicyAttributes = new KeyRotationPolicyAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expiryTime".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.expiryTime = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyRotationPolicyAttributes;
        });
    }
}

