// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/** Management policy for a key. */
@Fluent
public final class KeyRotationPolicy implements JsonSerializable<KeyRotationPolicy> {
    /*
     * The key policy id.
     */
    private String id;

    /*
     * Actions that will be performed by Key Vault over the lifetime of a key. For preview, lifetimeActions can only
     * have two items at maximum: one for rotate, one for notify. Notification time would be default to 30 days before
     * expiry and it is not configurable.
     */
    private List<LifetimeActions> lifetimeActions;

    /*
     * The key rotation policy attributes.
     */
    private KeyRotationPolicyAttributes attributes;

    /** Creates an instance of KeyRotationPolicy class. */
    public KeyRotationPolicy() {}

    /**
     * Get the id property: The key policy id.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the lifetimeActions property: Actions that will be performed by Key Vault over the lifetime of a key. For
     * preview, lifetimeActions can only have two items at maximum: one for rotate, one for notify. Notification time
     * would be default to 30 days before expiry and it is not configurable.
     *
     * @return the lifetimeActions value.
     */
    public List<LifetimeActions> getLifetimeActions() {
        return this.lifetimeActions;
    }

    /**
     * Set the lifetimeActions property: Actions that will be performed by Key Vault over the lifetime of a key. For
     * preview, lifetimeActions can only have two items at maximum: one for rotate, one for notify. Notification time
     * would be default to 30 days before expiry and it is not configurable.
     *
     * @param lifetimeActions the lifetimeActions value to set.
     * @return the KeyRotationPolicy object itself.
     */
    public KeyRotationPolicy setLifetimeActions(List<LifetimeActions> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    /**
     * Get the attributes property: The key rotation policy attributes.
     *
     * @return the attributes value.
     */
    public KeyRotationPolicyAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The key rotation policy attributes.
     *
     * @param attributes the attributes value to set.
     * @return the KeyRotationPolicy object itself.
     */
    public KeyRotationPolicy setAttributes(KeyRotationPolicyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField(
                "lifetimeActions", this.lifetimeActions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("attributes", this.attributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyRotationPolicy from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyRotationPolicy if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyRotationPolicy.
     */
    public static KeyRotationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyRotationPolicy deserializedKeyRotationPolicy = new KeyRotationPolicy();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("id".equals(fieldName)) {
                            deserializedKeyRotationPolicy.id = reader.getString();
                        } else if ("lifetimeActions".equals(fieldName)) {
                            List<LifetimeActions> lifetimeActions =
                                    reader.readArray(reader1 -> LifetimeActions.fromJson(reader1));
                            deserializedKeyRotationPolicy.lifetimeActions = lifetimeActions;
                        } else if ("attributes".equals(fieldName)) {
                            deserializedKeyRotationPolicy.attributes = KeyRotationPolicyAttributes.fromJson(reader);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyRotationPolicy;
                });
    }
}
