// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** The key create parameters. */
@Fluent
public final class KeyCreateParameters implements JsonSerializable<KeyCreateParameters> {
    /*
     * JsonWebKey Key Type (kty), as defined in https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     */
    private KeyType kty;

    /*
     * The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    private Integer keySize;

    /*
     * The public exponent for a RSA key.
     */
    private Integer publicExponent;

    /*
     * The key_ops property.
     */
    private List<KeyOperation> keyOps;

    /*
     * The attributes of a key managed by the key vault service.
     */
    private KeyAttributes keyAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /*
     * Elliptic curve name.
     */
    private KeyCurveName crv;

    /*
     * The policy rules under which the key can be exported.
     */
    private KeyReleasePolicy releasePolicy;

    /** Creates an instance of KeyCreateParameters class. */
    public KeyCreateParameters() {}

    /**
     * Get the kty property: JsonWebKey Key Type (kty), as defined in
     * https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     *
     * @return the kty value.
     */
    public KeyType getKty() {
        return this.kty;
    }

    /**
     * Set the kty property: JsonWebKey Key Type (kty), as defined in
     * https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     *
     * @param kty the kty value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setKty(KeyType kty) {
        this.kty = kty;
        return this;
    }

    /**
     * Get the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     *
     * @return the keySize value.
     */
    public Integer getKeySize() {
        return this.keySize;
    }

    /**
     * Set the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     *
     * @param keySize the keySize value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the publicExponent property: The public exponent for a RSA key.
     *
     * @return the publicExponent value.
     */
    public Integer getPublicExponent() {
        return this.publicExponent;
    }

    /**
     * Set the publicExponent property: The public exponent for a RSA key.
     *
     * @param publicExponent the publicExponent value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setPublicExponent(Integer publicExponent) {
        this.publicExponent = publicExponent;
        return this;
    }

    /**
     * Get the keyOps property: The key_ops property.
     *
     * @return the keyOps value.
     */
    public List<KeyOperation> getKeyOps() {
        return this.keyOps;
    }

    /**
     * Set the keyOps property: The key_ops property.
     *
     * @param keyOps the keyOps value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    /**
     * Get the keyAttributes property: The attributes of a key managed by the key vault service.
     *
     * @return the keyAttributes value.
     */
    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    /**
     * Set the keyAttributes property: The attributes of a key managed by the key vault service.
     *
     * @param keyAttributes the keyAttributes value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @param tags the tags value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the crv property: Elliptic curve name.
     *
     * @return the crv value.
     */
    public KeyCurveName getCrv() {
        return this.crv;
    }

    /**
     * Set the crv property: Elliptic curve name.
     *
     * @param crv the crv value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setCrv(KeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    /**
     * Get the releasePolicy property: The policy rules under which the key can be exported.
     *
     * @return the releasePolicy value.
     */
    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    /**
     * Set the releasePolicy property: The policy rules under which the key can be exported.
     *
     * @param releasePolicy the releasePolicy value to set.
     * @return the KeyCreateParameters object itself.
     */
    public KeyCreateParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kty", Objects.toString(this.kty, null));
        jsonWriter.writeNumberField("key_size", this.keySize);
        jsonWriter.writeNumberField("public_exponent", this.publicExponent);
        jsonWriter.writeArrayField(
                "key_ops", this.keyOps, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("crv", Objects.toString(this.crv, null));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyCreateParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyCreateParameters if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyCreateParameters.
     */
    public static KeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    KeyCreateParameters deserializedKeyCreateParameters = new KeyCreateParameters();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("kty".equals(fieldName)) {
                            deserializedKeyCreateParameters.kty = KeyType.fromString(reader.getString());
                        } else if ("key_size".equals(fieldName)) {
                            deserializedKeyCreateParameters.keySize = reader.getNullable(JsonReader::getInt);
                        } else if ("public_exponent".equals(fieldName)) {
                            deserializedKeyCreateParameters.publicExponent = reader.getNullable(JsonReader::getInt);
                        } else if ("key_ops".equals(fieldName)) {
                            List<KeyOperation> keyOps =
                                    reader.readArray(reader1 -> KeyOperation.fromString(reader1.getString()));
                            deserializedKeyCreateParameters.keyOps = keyOps;
                        } else if ("attributes".equals(fieldName)) {
                            deserializedKeyCreateParameters.keyAttributes = KeyAttributes.fromJson(reader);
                        } else if ("tags".equals(fieldName)) {
                            Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                            deserializedKeyCreateParameters.tags = tags;
                        } else if ("crv".equals(fieldName)) {
                            deserializedKeyCreateParameters.crv = KeyCurveName.fromString(reader.getString());
                        } else if ("release_policy".equals(fieldName)) {
                            deserializedKeyCreateParameters.releasePolicy = KeyReleasePolicy.fromJson(reader);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedKeyCreateParameters;
                });
    }
}
