// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/** A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info. */
@Fluent
public final class DeletedKeyBundle extends KeyBundle {
    /*
     * The url of the recovery object, used to identify and recover the deleted key.
     */
    private String recoveryId;

    /*
     * The time when the key is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the key was deleted, in UTC
     */
    private Long deletedDate;

    /** Creates an instance of DeletedKeyBundle class. */
    public DeletedKeyBundle() {}

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted key.
     *
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted key.
     *
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedKeyBundle object itself.
     */
    public DeletedKeyBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the key is scheduled to be purged, in UTC.
     *
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the key was deleted, in UTC.
     *
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyBundle setKey(JsonWebKey key) {
        super.setKey(key);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyBundle setAttributes(KeyAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedKeyBundle setReleasePolicy(KeyReleasePolicy releasePolicy) {
        super.setReleasePolicy(releasePolicy);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", getKey());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", getReleasePolicy());
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedKeyBundle from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedKeyBundle if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedKeyBundle.
     */
    public static DeletedKeyBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    DeletedKeyBundle deserializedDeletedKeyBundle = new DeletedKeyBundle();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("key".equals(fieldName)) {
                            deserializedDeletedKeyBundle.setKey(JsonWebKey.fromJson(reader));
                        } else if ("attributes".equals(fieldName)) {
                            deserializedDeletedKeyBundle.setAttributes(KeyAttributes.fromJson(reader));
                        } else if ("tags".equals(fieldName)) {
                            Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                            deserializedDeletedKeyBundle.setTags(tags);
                        } else if ("managed".equals(fieldName)) {
                            deserializedDeletedKeyBundle.setManaged(reader.getNullable(JsonReader::getBoolean));
                        } else if ("release_policy".equals(fieldName)) {
                            deserializedDeletedKeyBundle.setReleasePolicy(KeyReleasePolicy.fromJson(reader));
                        } else if ("recoveryId".equals(fieldName)) {
                            deserializedDeletedKeyBundle.recoveryId = reader.getString();
                        } else if ("scheduledPurgeDate".equals(fieldName)) {
                            deserializedDeletedKeyBundle.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                        } else if ("deletedDate".equals(fieldName)) {
                            deserializedDeletedKeyBundle.deletedDate = reader.getNullable(JsonReader::getLong);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedDeletedKeyBundle;
                });
    }
}
