/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;

public final class EncryptResult {
    private final byte[] ciphertext;
    private final EncryptionAlgorithm algorithm;
    private final String keyId;
    private final byte[] iv;
    private final byte[] authenticationTag;
    private final byte[] additionalAuthenticatedData;

    public EncryptResult(byte[] ciphertext, EncryptionAlgorithm algorithm, String keyId) {
        this(ciphertext, algorithm, keyId, null, null, null);
    }

    public EncryptResult(byte[] ciphertext, EncryptionAlgorithm algorithm, String keyId, byte[] iv, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        this.ciphertext = CoreUtils.clone((byte[])ciphertext);
        this.algorithm = algorithm;
        this.keyId = keyId;
        this.iv = CoreUtils.clone((byte[])iv);
        this.authenticationTag = CoreUtils.clone((byte[])authenticationTag);
        this.additionalAuthenticatedData = CoreUtils.clone((byte[])additionalAuthenticatedData);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public byte[] getCipherText() {
        return CoreUtils.clone((byte[])this.ciphertext);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getIv() {
        return CoreUtils.clone((byte[])this.iv);
    }

    public byte[] getAuthenticationTag() {
        return CoreUtils.clone((byte[])this.authenticationTag);
    }

    public byte[] getAdditionalAuthenticatedData() {
        return CoreUtils.clone((byte[])this.additionalAuthenticatedData);
    }
}

