/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyService;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.Objects;

@ServiceClient(builder=CryptographyClientBuilder.class, serviceInterfaces={CryptographyService.class})
public class CryptographyClient {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClient.class);
    private final String keyCollection;
    private volatile boolean localOperationNotSupported = false;
    private LocalKeyCryptographyClient localKeyCryptographyClient;
    final CryptographyClientImpl implClient;
    final String keyId;
    volatile JsonWebKey key;

    CryptographyClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version) {
        this.keyCollection = CryptographyClientImpl.unpackAndValidateId(keyId);
        this.keyId = keyId;
        this.implClient = new CryptographyClientImpl(keyId, pipeline, version);
        this.key = null;
    }

    CryptographyClient(JsonWebKey jsonWebKey) {
        Objects.requireNonNull(jsonWebKey, "The JSON Web Key is required.");
        if (!jsonWebKey.isValid()) {
            throw new IllegalArgumentException("The JSON Web Key is not valid.");
        }
        if (jsonWebKey.getKeyOps() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key operations property is not configured.");
        }
        if (jsonWebKey.getKeyType() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key type property is not configured.");
        }
        this.keyCollection = null;
        this.key = jsonWebKey;
        this.keyId = jsonWebKey.getId();
        this.implClient = null;
        this.localKeyCryptographyClient = CryptographyClientImpl.initializeCryptoClient(this.key, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey() {
        return (KeyVaultKey)this.getKeyWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(Context context) {
        if (this.implClient != null) {
            return this.implClient.getKey(context);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Operation not supported when in operating local-only mode"));
    }

    JsonWebKey getSecretKey() {
        try {
            return (JsonWebKey)this.implClient.getSecretKey(Context.NONE).getValue();
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        return this.encrypt(algorithm, plaintext, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.encrypt(algorithm, plaintext, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.ENCRYPT)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Encrypt operation is missing permission/not supported for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.encrypt(algorithm, plaintext, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.encrypt(encryptParameters, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.ENCRYPT)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Encrypt operation is missing permission/not supported for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.encrypt(encryptParameters, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext) {
        return this.decrypt(algorithm, ciphertext, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.decrypt(algorithm, ciphertext, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.DECRYPT)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Decrypt operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.decrypt(algorithm, ciphertext, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.decrypt(decryptParameters, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.DECRYPT)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Decrypt operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.decrypt(decryptParameters, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest) {
        return this.sign(algorithm, digest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.sign(algorithm, digest, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.sign(algorithm, digest, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verify(algorithm, digest, signature, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.verify(algorithm, digest, signature, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.verify(algorithm, digest, signature, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        return this.wrapKey(algorithm, key, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.wrapKey(algorithm, key, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.WRAP_KEY)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Wrap key operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.wrapKey(algorithm, key, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        return this.unwrapKey(algorithm, encryptedKey, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.unwrapKey(algorithm, encryptedKey, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.UNWRAP_KEY)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Unwrap key operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.unwrapKey(algorithm, encryptedKey, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data) {
        return this.signData(algorithm, data, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.signData(algorithm, data, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.signData(algorithm, data, this.key, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        return this.verifyData(algorithm, data, signature, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        if (!this.isValidKeyLocallyAvailable()) {
            return this.implClient.verifyData(algorithm, data, signature, context);
        }
        if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId())));
        }
        return this.localKeyCryptographyClient.verifyData(algorithm, data, signature, this.key, context);
    }

    private boolean isValidKeyLocallyAvailable() {
        boolean keyNotAvailable;
        if (this.localOperationNotSupported) {
            return false;
        }
        boolean bl = keyNotAvailable = this.key == null && this.keyCollection != null;
        if (keyNotAvailable) {
            this.key = Objects.equals(this.keyCollection, "secrets") ? this.getSecretKey() : this.getKey().getKey();
        }
        if (this.key == null) {
            return false;
        }
        if (this.key.isValid()) {
            if (this.localKeyCryptographyClient == null) {
                try {
                    this.localKeyCryptographyClient = CryptographyClientImpl.initializeCryptoClient(this.key, this.implClient);
                }
                catch (RuntimeException e) {
                    this.localOperationNotSupported = true;
                    LOGGER.warning("Defaulting to service use for cryptographic operations.", new Object[]{e});
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    CryptographyClientImpl getImplClient() {
        return this.implClient;
    }
}

