/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.LocalKeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.SymmetricEncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import reactor.core.publisher.Mono;

class AesKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private static final ClientLogger LOGGER = new ClientLogger(AesKeyCryptographyClient.class);
    private byte[] key;
    static final int AES_BLOCK_SIZE = 16;

    AesKeyCryptographyClient(CryptographyClientImpl serviceClient) {
        super(serviceClient);
    }

    AesKeyCryptographyClient(JsonWebKey key, CryptographyClientImpl serviceClient) {
        super(serviceClient);
        this.key = key.toAes().getEncoded();
    }

    private byte[] getKey(JsonWebKey key) {
        if (this.key == null) {
            this.key = key.toAes().getEncoded();
        }
        return this.key;
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        try {
            return this.encryptInternalAsync(algorithm, plaintext, null, null, jsonWebKey, context);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        return this.encryptInternal(algorithm, plaintext, null, null, jsonWebKey, context);
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        try {
            return this.encryptInternalAsync(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), jsonWebKey, context);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    EncryptResult encrypt(EncryptParameters encryptParameters, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encryptInternal(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), jsonWebKey, context);
    }

    private Mono<EncryptResult> encryptInternalAsync(EncryptionAlgorithm algorithm, byte[] plaintext, byte[] iv, byte[] additionalAuthenticatedData, JsonWebKey jsonWebKey, Context context) {
        byte[] ciphertext;
        ICryptoTransform transform;
        if (this.isGcm(algorithm)) {
            return Mono.error((Throwable)new UnsupportedOperationException("AES-GCM is not supported for local cryptography operations."));
        }
        if (!this.isAes(algorithm)) {
            return Mono.error((Throwable)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
        }
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            return Mono.error((Throwable)new IllegalArgumentException("Key is empty."));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        if (iv == null) {
            if (this.isAes(algorithm)) {
                iv = this.generateRandomByteArray(16);
            } else {
                return Mono.error((Throwable)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
            }
        }
        try {
            transform = symmetricEncryptionAlgorithm.createEncryptor(this.key, iv, additionalAuthenticatedData, null);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        try {
            ciphertext = transform.doFinal(plaintext);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new EncryptResult(ciphertext, algorithm, jsonWebKey.getId(), iv, null, additionalAuthenticatedData));
    }

    private EncryptResult encryptInternal(EncryptionAlgorithm algorithm, byte[] plaintext, byte[] iv, byte[] additionalAuthenticatedData, JsonWebKey jsonWebKey, Context context) {
        byte[] ciphertext;
        ICryptoTransform transform;
        if (this.isGcm(algorithm)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("AES-GCM is not supported for local cryptography operations."));
        }
        if (!this.isAes(algorithm)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
        }
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key is empty."));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        if (iv == null) {
            if (this.isAes(algorithm)) {
                iv = this.generateRandomByteArray(16);
            } else {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
            }
        }
        try {
            transform = symmetricEncryptionAlgorithm.createEncryptor(this.key, iv, additionalAuthenticatedData, null);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        try {
            ciphertext = transform.doFinal(plaintext);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        return new EncryptResult(ciphertext, algorithm, jsonWebKey.getId(), iv, null, additionalAuthenticatedData);
    }

    @Override
    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        try {
            return this.decryptInternalAsync(algorithm, ciphertext, null, null, null, jsonWebKey, context);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        return this.decryptInternal(algorithm, ciphertext, null, null, null, jsonWebKey, context);
    }

    @Override
    Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, JsonWebKey jsonWebKey, Context context) {
        try {
            return this.decryptInternalAsync(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), jsonWebKey, context);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    DecryptResult decrypt(DecryptParameters decryptParameters, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decryptInternal(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), jsonWebKey, context);
    }

    private Mono<DecryptResult> decryptInternalAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, JsonWebKey jsonWebKey, Context context) {
        byte[] plaintext;
        ICryptoTransform transform;
        if (this.isGcm(algorithm)) {
            return Mono.error((Throwable)new UnsupportedOperationException("AES-GCM is not supported for local cryptography operations."));
        }
        if (!this.isAes(algorithm)) {
            return Mono.error((Throwable)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
        }
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            return Mono.error((Throwable)new IllegalArgumentException("Key is empty."));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        Objects.requireNonNull(iv, "'iv' cannot be null in local decryption operations.");
        try {
            transform = symmetricEncryptionAlgorithm.createDecryptor(this.key, iv, additionalAuthenticatedData, authenticationTag);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        try {
            plaintext = transform.doFinal(ciphertext);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new DecryptResult(plaintext, algorithm, jsonWebKey.getId()));
    }

    private DecryptResult decryptInternal(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, JsonWebKey jsonWebKey, Context context) {
        byte[] plaintext;
        ICryptoTransform transform;
        if (this.isGcm(algorithm)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("AES-GCM is not supported for local cryptography operations."));
        }
        if (!this.isAes(algorithm)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Encryption algorithm provided is not supported: " + (Object)((Object)algorithm)));
        }
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key is empty."));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        Objects.requireNonNull(iv, "'iv' cannot be null in local decryption operations.");
        try {
            transform = symmetricEncryptionAlgorithm.createDecryptor(this.key, iv, additionalAuthenticatedData, authenticationTag);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        try {
            plaintext = transform.doFinal(ciphertext);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        return new DecryptResult(plaintext, algorithm, jsonWebKey.getId());
    }

    @Override
    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Sign operation not supported for OCT/Symmetric key."));
    }

    @Override
    SignResult sign(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Sign operation not supported for OCT/Symmetric key."));
    }

    @Override
    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Verify operation not supported for OCT/Symmetric key."));
    }

    @Override
    VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Verify operation not supported for OCT/Symmetric key."));
    }

    @Override
    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] keyToWrap, JsonWebKey jsonWebKey, Context context) {
        byte[] encrypted;
        ICryptoTransform transform;
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(keyToWrap, "Key content to be wrapped cannot be null.");
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("key"));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        LocalKeyWrapAlgorithm localKeyWrapAlgorithm = (LocalKeyWrapAlgorithm)baseAlgorithm;
        try {
            transform = localKeyWrapAlgorithm.createEncryptor(this.key, null, null);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        try {
            encrypted = transform.doFinal(keyToWrap);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new WrapResult(encrypted, algorithm, jsonWebKey.getId()));
    }

    @Override
    WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] keyToWrap, JsonWebKey jsonWebKey, Context context) {
        byte[] encrypted;
        ICryptoTransform transform;
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(keyToWrap, "Key content to be wrapped cannot be null.");
        this.key = this.getKey(jsonWebKey);
        if (this.key == null || this.key.length == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("key"));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        LocalKeyWrapAlgorithm localKeyWrapAlgorithm = (LocalKeyWrapAlgorithm)baseAlgorithm;
        try {
            transform = localKeyWrapAlgorithm.createEncryptor(this.key, null, null);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        try {
            encrypted = transform.doFinal(keyToWrap);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        return new WrapResult(encrypted, algorithm, jsonWebKey.getId());
    }

    @Override
    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey jsonWebKey, Context context) {
        byte[] decrypted;
        ICryptoTransform transform;
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        this.key = this.getKey(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        LocalKeyWrapAlgorithm localKeyWrapAlgorithm = (LocalKeyWrapAlgorithm)baseAlgorithm;
        try {
            transform = localKeyWrapAlgorithm.createDecryptor(this.key, null, null);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        try {
            decrypted = transform.doFinal(encryptedKey);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new UnwrapResult(decrypted, algorithm, jsonWebKey.getId()));
    }

    @Override
    UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey jsonWebKey, Context context) {
        byte[] decrypted;
        ICryptoTransform transform;
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        this.key = this.getKey(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (!(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        LocalKeyWrapAlgorithm localKeyWrapAlgorithm = (LocalKeyWrapAlgorithm)baseAlgorithm;
        try {
            transform = localKeyWrapAlgorithm.createDecryptor(this.key, null, null);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        try {
            decrypted = transform.doFinal(encryptedKey);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        return new UnwrapResult(decrypted, algorithm, jsonWebKey.getId());
    }

    @Override
    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        return this.signAsync(algorithm, data, key, context);
    }

    @Override
    SignResult signData(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        return this.sign(algorithm, data, key, context);
    }

    @Override
    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        return this.verifyAsync(algorithm, data, signature, key, context);
    }

    @Override
    VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        return this.verify(algorithm, data, signature, key, context);
    }

    private byte[] generateRandomByteArray(int sizeInBytes) {
        byte[] iv = new byte[]{};
        try {
            SecureRandom randomSecureRandom = SecureRandom.getInstance("SHA1PRNG");
            iv = new byte[sizeInBytes];
            randomSecureRandom.nextBytes(iv);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.logThrowableAsError((Throwable)e);
        }
        return iv;
    }

    private boolean isAes(EncryptionAlgorithm encryptionAlgorithm) {
        return encryptionAlgorithm == EncryptionAlgorithm.A128CBC || encryptionAlgorithm == EncryptionAlgorithm.A192CBC || encryptionAlgorithm == EncryptionAlgorithm.A256CBC || encryptionAlgorithm == EncryptionAlgorithm.A128CBCPAD || encryptionAlgorithm == EncryptionAlgorithm.A192CBCPAD || encryptionAlgorithm == EncryptionAlgorithm.A256CBCPAD;
    }

    private boolean isGcm(EncryptionAlgorithm encryptionAlgorithm) {
        return encryptionAlgorithm == EncryptionAlgorithm.A128GCM || encryptionAlgorithm == EncryptionAlgorithm.A192GCM || encryptionAlgorithm == EncryptionAlgorithm.A256GCM;
    }
}

