/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.AesKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.EcKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.RsaKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.Strings;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyService;
import com.azure.security.keyvault.keys.cryptography.implementation.KeyOperationParameters;
import com.azure.security.keyvault.keys.cryptography.implementation.KeyOperationResult;
import com.azure.security.keyvault.keys.cryptography.implementation.KeySignRequest;
import com.azure.security.keyvault.keys.cryptography.implementation.KeyVerifyRequest;
import com.azure.security.keyvault.keys.cryptography.implementation.KeyVerifyResponse;
import com.azure.security.keyvault.keys.cryptography.implementation.KeyWrapUnwrapRequest;
import com.azure.security.keyvault.keys.cryptography.implementation.SecretKey;
import com.azure.security.keyvault.keys.cryptography.implementation.SecretRequestAttributes;
import com.azure.security.keyvault.keys.cryptography.implementation.SecretRequestParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

class CryptographyClientImpl {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClientImpl.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    static final String SECRETS_COLLECTION = "secrets";
    private final CryptographyService service;
    private final String serviceVersion;
    private final String keyId;
    private String vaultUrl;
    private String keyName;
    private String version;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";

    CryptographyClientImpl(String keyId, HttpPipeline pipeline, CryptographyServiceVersion serviceVersion) {
        Objects.requireNonNull(keyId);
        this.unpackId(keyId);
        this.keyId = keyId;
        this.service = (CryptographyService)RestProxy.create(CryptographyService.class, (HttpPipeline)pipeline);
        this.serviceVersion = serviceVersion.getVersion();
    }

    String getVaultUrl() {
        return this.vaultUrl;
    }

    Mono<String> getKeyIdAsync() {
        return Mono.defer(() -> Mono.just((Object)this.keyId));
    }

    String getKeyId() {
        return this.keyId;
    }

    Mono<Response<KeyVaultKey>> getKeyAsync(Context context) {
        if (this.version == null) {
            this.version = "";
        }
        return this.getKeyAsync(this.keyName, this.version, context);
    }

    Response<KeyVaultKey> getKey(Context context) {
        if (this.version == null) {
            this.version = "";
        }
        return this.getKey(this.keyName, this.version, context);
    }

    private Mono<Response<KeyVaultKey>> getKeyAsync(String name, String version, Context context) {
        return this.service.getKeyAsync(this.vaultUrl, name, version, this.serviceVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving key - {}", new Object[]{name})).doOnSuccess(response -> LOGGER.verbose("Retrieved key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    private Response<KeyVaultKey> getKey(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getKey(this.vaultUrl, name, version, this.serviceVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
    }

    Mono<Response<JsonWebKey>> getSecretKeyAsync(Context context) {
        return this.service.getSecretAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving key - {}", new Object[]{this.keyName})).doOnSuccess(response -> LOGGER.verbose("Retrieved key - {}", new Object[]{((SecretKey)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to get key - {}", new Object[]{this.keyName, error})).flatMap(stringResponse -> {
            try {
                return Mono.just((Object)new SimpleResponse(stringResponse.getRequest(), stringResponse.getStatusCode(), stringResponse.getHeaders(), (Object)this.transformSecretKey((SecretKey)stringResponse.getValue())));
            }
            catch (JsonProcessingException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    Response<JsonWebKey> getSecretKey(Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<SecretKey> secretKeyResponse = this.service.getSecret(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context);
        try {
            return new SimpleResponse(secretKeyResponse.getRequest(), secretKeyResponse.getStatusCode(), secretKeyResponse.getHeaders(), (Object)this.transformSecretKey((SecretKey)secretKeyResponse.getValue()));
        }
        catch (JsonProcessingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    Mono<Response<SecretKey>> setSecretKeyAsync(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The secret key cannot be null.");
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(secret.getValue()).setTags(secret.getProperties().getTags()).setContentType(secret.getProperties().getContentType()).setSecretAttributes(new SecretRequestAttributes(secret.getProperties()));
        return this.service.setSecretAsync(this.vaultUrl, secret.getName(), this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Setting secret - {}", new Object[]{secret.getName()})).doOnSuccess(response -> LOGGER.verbose("Set secret - {}", new Object[]{((SecretKey)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to set secret - {}", new Object[]{secret.getName(), error}));
    }

    Response<SecretKey> setSecretKey(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(secret.getValue()).setTags(secret.getProperties().getTags()).setContentType(secret.getProperties().getContentType()).setSecretAttributes(new SecretRequestAttributes(secret.getProperties()));
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.setSecret(this.vaultUrl, secret.getName(), this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
    }

    JsonWebKey transformSecretKey(SecretKey secretKey) throws JsonProcessingException {
        ObjectNode rootNode = MAPPER.createObjectNode();
        ArrayNode a = MAPPER.createArrayNode();
        a.add(KeyOperation.WRAP_KEY.toString());
        a.add(KeyOperation.UNWRAP_KEY.toString());
        a.add(KeyOperation.ENCRYPT.toString());
        a.add(KeyOperation.DECRYPT.toString());
        rootNode.put("k", Base64.getUrlDecoder().decode(secretKey.getValue()));
        rootNode.put("kid", this.keyId);
        rootNode.put("kty", KeyType.OCT.toString());
        rootNode.set("key_ops", (JsonNode)a);
        return (JsonWebKey)MAPPER.treeToValue((TreeNode)rootNode, JsonWebKey.class);
    }

    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(plaintext);
        return this.encryptAsync(parameters, context);
    }

    Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(encryptParameters.getAlgorithm()).setValue(encryptParameters.getPlainText()).setIv(encryptParameters.getIv()).setAdditionalAuthenticatedData(encryptParameters.getAdditionalAuthenticatedData());
        return this.encryptAsync(parameters, context);
    }

    private Mono<EncryptResult> encryptAsync(KeyOperationParameters keyOperationParameters, Context context) {
        EncryptionAlgorithm algorithm = keyOperationParameters.getAlgorithm();
        return this.service.encryptAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, keyOperationParameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Encrypting content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved encrypted content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to encrypt content with algorithm - {}", new Object[]{algorithm, error})).map(keyOperationResultResponse -> {
            KeyOperationResult keyOperationResult = (KeyOperationResult)keyOperationResultResponse.getValue();
            return new EncryptResult(keyOperationResult.getResult(), algorithm, this.keyId, keyOperationResult.getIv(), keyOperationResult.getAuthenticationTag(), keyOperationResult.getAdditionalAuthenticatedData());
        });
    }

    EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(plaintext);
        return this.encrypt(parameters, context);
    }

    EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(encryptParameters.getAlgorithm()).setValue(encryptParameters.getPlainText()).setIv(encryptParameters.getIv()).setAdditionalAuthenticatedData(encryptParameters.getAdditionalAuthenticatedData());
        return this.encrypt(parameters, context);
    }

    EncryptResult encrypt(KeyOperationParameters keyOperationParameters, Context context) {
        EncryptionAlgorithm algorithm = keyOperationParameters.getAlgorithm();
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyOperationResult> encryptResult = this.service.encrypt(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, keyOperationParameters, CONTENT_TYPE_HEADER_VALUE, context);
        KeyOperationResult keyOperationResult = (KeyOperationResult)encryptResult.getValue();
        return new EncryptResult(keyOperationResult.getResult(), algorithm, this.keyId, keyOperationResult.getIv(), keyOperationResult.getAuthenticationTag(), keyOperationResult.getAdditionalAuthenticatedData());
    }

    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(ciphertext);
        return this.decryptAsync(parameters, context);
    }

    Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(decryptParameters.getAlgorithm()).setValue(decryptParameters.getCipherText()).setIv(decryptParameters.getIv()).setAdditionalAuthenticatedData(decryptParameters.getAdditionalAuthenticatedData()).setAuthenticationTag(decryptParameters.getAuthenticationTag());
        return this.decryptAsync(parameters, context);
    }

    private Mono<DecryptResult> decryptAsync(KeyOperationParameters keyOperationParameters, Context context) {
        EncryptionAlgorithm algorithm = keyOperationParameters.getAlgorithm();
        return this.service.decryptAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, keyOperationParameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Decrypting content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved decrypted content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to decrypt content with algorithm - {}", new Object[]{algorithm, error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new DecryptResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(algorithm).setValue(ciphertext);
        return this.decrypt(parameters, context);
    }

    DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        KeyOperationParameters parameters = new KeyOperationParameters().setAlgorithm(decryptParameters.getAlgorithm()).setValue(decryptParameters.getCipherText()).setIv(decryptParameters.getIv()).setAdditionalAuthenticatedData(decryptParameters.getAdditionalAuthenticatedData()).setAuthenticationTag(decryptParameters.getAuthenticationTag());
        return this.decrypt(parameters, context);
    }

    private DecryptResult decrypt(KeyOperationParameters keyOperationParameters, Context context) {
        EncryptionAlgorithm algorithm = keyOperationParameters.getAlgorithm();
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyOperationResult> decryptResult = this.service.decrypt(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, keyOperationParameters, CONTENT_TYPE_HEADER_VALUE, context);
        return new DecryptResult(((KeyOperationResult)decryptResult.getValue()).getResult(), algorithm, this.keyId);
    }

    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        KeySignRequest parameters = new KeySignRequest().setAlgorithm(algorithm).setValue(digest);
        return this.service.signAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Signing content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved signed content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to sign content with algorithm - {}", new Object[]{algorithm, error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new SignResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        KeySignRequest parameters = new KeySignRequest().setAlgorithm(algorithm).setValue(digest);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyOperationResult> signResponse = this.service.sign(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
        return new SignResult(((KeyOperationResult)signResponse.getValue()).getResult(), algorithm, this.keyId);
    }

    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        KeyVerifyRequest parameters = new KeyVerifyRequest().setAlgorithm(algorithm).setDigest(digest).setSignature(signature);
        return this.service.verifyAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Verifying content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved verified content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to verify content with algorithm - {}", new Object[]{algorithm, error})).flatMap(response -> Mono.just((Object)new VerifyResult(((KeyVerifyResponse)response.getValue()).getValue(), algorithm, this.keyId)));
    }

    VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        KeyVerifyRequest parameters = new KeyVerifyRequest().setAlgorithm(algorithm).setDigest(digest).setSignature(signature);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyVerifyResponse> verifyResult = this.service.verify(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
        return new VerifyResult(((KeyVerifyResponse)verifyResult.getValue()).getValue(), algorithm, this.keyId);
    }

    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(key);
        return this.service.wrapKeyAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Wrapping key content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved wrapped key content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to verify content with algorithm - {}", new Object[]{algorithm, error})).flatMap(keyOperationResultResponse -> Mono.just((Object)new WrapResult(((KeyOperationResult)keyOperationResultResponse.getValue()).getResult(), algorithm, this.keyId)));
    }

    WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(key);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyOperationResult> wrapResponse = this.service.wrapKey(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
        return new WrapResult(((KeyOperationResult)wrapResponse.getValue()).getResult(), algorithm, this.keyId);
    }

    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(encryptedKey);
        return this.service.unwrapKeyAsync(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context).doOnRequest(ignored -> LOGGER.verbose("Unwrapping key content with algorithm - {}", new Object[]{algorithm})).doOnSuccess(response -> LOGGER.verbose("Retrieved unwrapped key content with algorithm - {}", new Object[]{algorithm})).doOnError(error -> LOGGER.warning("Failed to unwrap key content with algorithm - {}", new Object[]{algorithm, error})).flatMap(response -> Mono.just((Object)new UnwrapResult(((KeyOperationResult)response.getValue()).getResult(), algorithm, this.keyId)));
    }

    UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        KeyWrapUnwrapRequest parameters = new KeyWrapUnwrapRequest().setAlgorithm(algorithm).setValue(encryptedKey);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyOperationResult> unwrapResponse = this.service.unwrapKey(this.vaultUrl, this.keyName, this.version, this.serviceVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context);
        return new UnwrapResult(((KeyOperationResult)unwrapResponse.getValue()).getResult(), algorithm, this.keyId);
    }

    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.signAsync(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.sign(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verifyAsync(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verify(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private void unpackId(String keyId) {
        if (keyId != null && keyId.length() > 0) {
            try {
                URL url = new URL(keyId);
                String[] tokens = url.getPath().split("/");
                this.vaultUrl = url.getProtocol() + "://" + url.getHost();
                if (url.getPort() != -1) {
                    this.vaultUrl = this.vaultUrl + ":" + url.getPort();
                }
                this.keyName = tokens.length >= 3 ? tokens[2] : null;
                this.version = tokens.length >= 4 ? tokens[3] : "";
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    static String unpackAndValidateId(String keyId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyId' cannot be null or empty."));
        }
        try {
            String keyCollection;
            URL url = new URL(keyId);
            String[] tokens = url.getPath().split("/");
            String endpoint = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() != -1) {
                endpoint = endpoint + ":" + url.getPort();
            }
            String keyName = tokens.length >= 3 ? tokens[2] : null;
            String string = keyCollection = tokens.length >= 2 ? tokens[1] : null;
            if (Strings.isNullOrEmpty(endpoint)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key endpoint in key identifier is invalid."));
            }
            if (Strings.isNullOrEmpty(keyName)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key name in key identifier is invalid."));
            }
            return keyCollection;
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The key identifier is malformed.", e));
        }
    }

    static LocalKeyCryptographyClient initializeCryptoClient(JsonWebKey jsonWebKey, CryptographyClientImpl implClient) {
        if (!KeyType.values().contains((Object)jsonWebKey.getKeyType())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The JSON Web Key type: %s is not supported.", jsonWebKey.getKeyType().toString())));
        }
        try {
            if (jsonWebKey.getKeyType().equals((Object)KeyType.RSA) || jsonWebKey.getKeyType().equals((Object)KeyType.RSA_HSM)) {
                return new RsaKeyCryptographyClient(jsonWebKey, implClient);
            }
            if (jsonWebKey.getKeyType().equals((Object)KeyType.EC) || jsonWebKey.getKeyType().equals((Object)KeyType.EC_HSM)) {
                return new EcKeyCryptographyClient(jsonWebKey, implClient);
            }
            if (jsonWebKey.getKeyType().equals((Object)KeyType.OCT) || jsonWebKey.getKeyType().equals((Object)KeyType.OCT_HSM)) {
                return new AesKeyCryptographyClient(jsonWebKey, implClient);
            }
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not initialize local cryptography client.", e));
        }
        return null;
    }

    static boolean checkKeyPermissions(List<KeyOperation> operations, KeyOperation keyOperation) {
        return operations.contains((Object)keyOperation);
    }
}

