/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicyAttributes;
import com.azure.security.keyvault.keys.implementation.models.LifetimeAction;
import com.azure.security.keyvault.keys.models.KeyRotationLifetimeAction;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;

public final class KeyRotationPolicy {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    private List<KeyRotationLifetimeAction> lifetimeActions;
    private KeyRotationPolicyAttributes attributes;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;

    public String getId() {
        return this.id;
    }

    public List<KeyRotationLifetimeAction> getLifetimeActions() {
        return this.lifetimeActions;
    }

    public KeyRotationPolicy setLifetimeActions(List<KeyRotationLifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    public String getExpiresIn() {
        return this.attributes == null ? null : this.attributes.getExpiryTime();
    }

    public KeyRotationPolicy setExpiresIn(String expiresIn) {
        if (this.attributes == null) {
            this.attributes = new KeyRotationPolicyAttributes();
        }
        this.attributes.setExpiryTime(expiresIn);
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    @JsonProperty(value="lifetimeActions")
    private void unpackLifetimeActions(List<LifetimeAction> lifetimeActions) {
        if (lifetimeActions != null) {
            this.lifetimeActions = new ArrayList<KeyRotationLifetimeAction>();
            for (LifetimeAction lifetimeAction : lifetimeActions) {
                this.lifetimeActions.add(new KeyRotationLifetimeAction(lifetimeAction.getAction().getType()).setTimeBeforeExpiry(lifetimeAction.getTrigger().getTimeBeforeExpiry()).setTimeAfterCreate(lifetimeAction.getTrigger().getTimeAfterCreate()));
            }
        }
    }

    @JsonProperty(value="attributes")
    private void unpackAttributes(KeyRotationPolicyAttributes attributes) {
        if (attributes != null) {
            this.attributes = attributes;
            this.createdOn = OffsetDateTime.of(LocalDateTime.ofEpochSecond(attributes.getCreatedOn(), 0, ZoneOffset.UTC), ZoneOffset.UTC);
            this.updatedOn = OffsetDateTime.of(LocalDateTime.ofEpochSecond(attributes.getUpdatedOn(), 0, ZoneOffset.UTC), ZoneOffset.UTC);
        }
    }
}

