/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.Asn1DerSignatureEncoding;
import com.azure.security.keyvault.keys.cryptography.Ecdsa;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

final class SignatureEncoding {
    private static final char[] HEX_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private SignatureEncoding() {
    }

    static byte[] fromAsn1Der(byte[] asn1DerSignature, String algorithm) throws NoSuchAlgorithmException {
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm);
        if (baseAlgorithm == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new IllegalArgumentException("Invalid algorithm; must be an instance of ECDSA.");
        }
        return SignatureEncoding.fromAsn1Der(asn1DerSignature, (Ecdsa)baseAlgorithm);
    }

    static byte[] fromAsn1Der(byte[] asn1DerSignature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.decode(asn1DerSignature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw (IllegalArgumentException)new IllegalArgumentException(ex.getMessage() + " " + Arrays.toString(SignatureEncoding.encodeHex(asn1DerSignature, HEX_LOWER))).initCause(ex);
        }
    }

    static byte[] toAsn1Der(byte[] signature, String algorithm) throws NoSuchAlgorithmException {
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm);
        if (baseAlgorithm == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new IllegalArgumentException("Invalid algorithm; must be an instance of ECDSA.");
        }
        return SignatureEncoding.toAsn1Der(signature, (Ecdsa)baseAlgorithm);
    }

    static byte[] toAsn1Der(byte[] signature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.encode(signature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw (IllegalArgumentException)new IllegalArgumentException(ex.getMessage() + " " + Arrays.toString(SignatureEncoding.encodeHex(signature, HEX_LOWER))).initCause(ex);
        }
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }
}

