/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.time.OffsetDateTime;
import java.util.Map;

public class CreateEcKeyOptions
extends CreateKeyOptions {
    private KeyCurveName curveName;
    private boolean hardwareProtected;

    public CreateEcKeyOptions(String name) {
        super(name, KeyType.EC);
    }

    public KeyCurveName getCurveName() {
        return this.curveName;
    }

    public CreateEcKeyOptions setCurveName(KeyCurveName curveName) {
        this.curveName = curveName;
        return this;
    }

    public Boolean isHardwareProtected() {
        return this.hardwareProtected;
    }

    public CreateEcKeyOptions setHardwareProtected(Boolean hardwareProtected) {
        this.hardwareProtected = hardwareProtected;
        KeyType keyType = hardwareProtected != false ? KeyType.EC_HSM : KeyType.EC;
        this.setKeyType(keyType);
        return this;
    }

    @Override
    public CreateEcKeyOptions setKeyOperations(KeyOperation ... keyOperations) {
        super.setKeyOperations(keyOperations);
        return this;
    }

    @Override
    public CreateEcKeyOptions setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public CreateEcKeyOptions setExpiresOn(OffsetDateTime expiresOn) {
        super.setExpiresOn(expiresOn);
        return this;
    }

    @Override
    public CreateEcKeyOptions setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public CreateEcKeyOptions setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }
}

