/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class RandomBytes
implements JsonSerializable<RandomBytes> {
    private final Base64Url value;

    private RandomBytes(byte[] value) {
        this.value = value == null ? null : Base64Url.encode((byte[])value);
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        return jsonWriter.writeEndObject();
    }

    public static RandomBytes fromJson(JsonReader jsonReader) throws IOException {
        return (RandomBytes)jsonReader.readObject(reader -> {
            byte[] value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    Base64Url valueHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder == null) continue;
                    value = valueHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new RandomBytes(value);
        });
    }
}

