/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeySignParameters
implements JsonSerializable<KeySignParameters> {
    private final JsonWebKeySignatureAlgorithm algorithm;
    private final Base64Url value;

    public KeySignParameters(JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value == null ? null : Base64Url.encode((byte[])value);
    }

    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        return jsonWriter.writeEndObject();
    }

    public static KeySignParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeySignParameters)jsonReader.readObject(reader -> {
            JsonWebKeySignatureAlgorithm algorithm = null;
            byte[] value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    Base64Url valueHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder == null) continue;
                    value = valueHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new KeySignParameters(algorithm, value);
        });
    }
}

