/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import java.io.IOException;

public final class KeyReleaseParameters
implements JsonSerializable<KeyReleaseParameters> {
    private final String targetAttestationToken;
    private String nonce;
    private KeyExportEncryptionAlgorithm enc;

    public KeyReleaseParameters(String targetAttestationToken) {
        this.targetAttestationToken = targetAttestationToken;
    }

    public String getTargetAttestationToken() {
        return this.targetAttestationToken;
    }

    public String getNonce() {
        return this.nonce;
    }

    public KeyReleaseParameters setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public KeyExportEncryptionAlgorithm getEnc() {
        return this.enc;
    }

    public KeyReleaseParameters setEnc(KeyExportEncryptionAlgorithm enc) {
        this.enc = enc;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.targetAttestationToken);
        jsonWriter.writeStringField("nonce", this.nonce);
        jsonWriter.writeStringField("enc", this.enc == null ? null : this.enc.toString());
        return jsonWriter.writeEndObject();
    }

    public static KeyReleaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyReleaseParameters)jsonReader.readObject(reader -> {
            String targetAttestationToken = null;
            String nonce = null;
            KeyExportEncryptionAlgorithm enc = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("target".equals(fieldName)) {
                    targetAttestationToken = reader.getString();
                    continue;
                }
                if ("nonce".equals(fieldName)) {
                    nonce = reader.getString();
                    continue;
                }
                if ("enc".equals(fieldName)) {
                    enc = KeyExportEncryptionAlgorithm.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            KeyReleaseParameters deserializedKeyReleaseParameters = new KeyReleaseParameters(targetAttestationToken);
            deserializedKeyReleaseParameters.nonce = nonce;
            deserializedKeyReleaseParameters.enc = enc;
            return deserializedKeyReleaseParameters;
        });
    }
}

